/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.Collections;
import java.util.List;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.delegate.DelegateExecution;
import org.operaton.bpm.engine.exception.NotFoundException;
import org.operaton.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.history.HistoryLevel;
import org.operaton.bpm.engine.impl.history.event.HistoryEvent;
import org.operaton.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.operaton.bpm.engine.impl.history.event.HistoryEventTypes;
import org.operaton.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.runtime.ProcessInstance;

public abstract class AbstractDeleteProcessInstanceCmd {
    protected boolean externallyTerminated;
    protected String deleteReason;
    protected boolean skipCustomListeners;
    protected boolean skipSubprocesses;
    protected boolean failIfNotExists = true;
    protected boolean skipIoMappings;

    protected void checkDeleteProcessInstance(ExecutionEntity execution, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteProcessInstance(execution);
        }
    }

    protected void deleteProcessInstances(CommandContext commandContext, List<String> processInstanceIds) {
        processInstanceIds.forEach(processInstance -> this.deleteProcessInstance(commandContext, (String)processInstance));
    }

    protected void deleteProcessInstance(CommandContext commandContext, String processInstanceId) {
        ExecutionEntity superExecution;
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "processInstanceId is null", "processInstanceId", (Object)processInstanceId);
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity execution = executionManager.findExecutionById(processInstanceId);
        if (!this.failIfNotExists && execution == null) {
            return;
        }
        EnsureUtil.ensureNotNull(NotFoundException.class, "No process instance found for id '" + processInstanceId + "'", "processInstance", (Object)execution);
        this.checkDeleteProcessInstance(execution, commandContext);
        commandContext.getExecutionManager().deleteProcessInstance(processInstanceId, this.deleteReason, false, this.skipCustomListeners, this.externallyTerminated, this.skipIoMappings, this.skipSubprocesses);
        if (this.skipSubprocesses) {
            List<ProcessInstance> superProcesslist = commandContext.getProcessEngineConfiguration().getRuntimeService().createProcessInstanceQuery().superProcessInstanceId(processInstanceId).list();
            this.triggerHistoryEvent(superProcesslist);
        }
        if ((superExecution = execution.getSuperExecution()) != null) {
            commandContext.runWithoutAuthorization(() -> {
                ProcessInstanceModificationBuilderImpl builder = (ProcessInstanceModificationBuilderImpl)new ProcessInstanceModificationBuilderImpl(commandContext, superExecution.getProcessInstanceId(), this.deleteReason).cancellationSourceExternal(this.externallyTerminated).cancelActivityInstance(superExecution.getActivityInstanceId());
                builder.execute(false, this.skipCustomListeners, this.skipIoMappings);
                return null;
            });
        }
        commandContext.getOperationLogManager().logProcessInstanceOperation("Delete", processInstanceId, null, null, Collections.singletonList(PropertyChange.EMPTY_CHANGE));
    }

    public void triggerHistoryEvent(List<ProcessInstance> subProcesslist) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        for (final ProcessInstance processInstance : subProcesslist) {
            if (!historyLevel.isHistoryEventProduced(HistoryEventTypes.PROCESS_INSTANCE_UPDATE, processInstance)) continue;
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createProcessInstanceUpdateEvt((DelegateExecution)((Object)processInstance));
                }
            });
        }
    }
}

