/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cfg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.impl.cfg.AbstractProcessEnginePlugin;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.cfg.ProcessEnginePlugin;

public class CompositeProcessEnginePlugin
extends AbstractProcessEnginePlugin {
    protected final List<ProcessEnginePlugin> plugins = new ArrayList<ProcessEnginePlugin>();

    public CompositeProcessEnginePlugin() {
    }

    public CompositeProcessEnginePlugin(ProcessEnginePlugin plugin, ProcessEnginePlugin ... additionalPlugins) {
        this();
        this.addProcessEnginePlugin(plugin, additionalPlugins);
    }

    public CompositeProcessEnginePlugin(List<ProcessEnginePlugin> plugins) {
        this();
        this.addProcessEnginePlugins(plugins);
    }

    public CompositeProcessEnginePlugin addProcessEnginePlugin(ProcessEnginePlugin plugin, ProcessEnginePlugin ... additionalPlugins) {
        return this.addProcessEnginePlugins(CompositeProcessEnginePlugin.toList(plugin, additionalPlugins));
    }

    public CompositeProcessEnginePlugin addProcessEnginePlugins(Collection<ProcessEnginePlugin> plugins) {
        this.plugins.addAll(plugins);
        return this;
    }

    @Override
    public void preInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        for (ProcessEnginePlugin plugin : this.plugins) {
            plugin.preInit(processEngineConfiguration);
        }
    }

    @Override
    public void postInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        for (ProcessEnginePlugin plugin : this.plugins) {
            plugin.postInit(processEngineConfiguration);
        }
    }

    @Override
    public void postProcessEngineBuild(ProcessEngine processEngine) {
        for (ProcessEnginePlugin plugin : this.plugins) {
            plugin.postProcessEngineBuild(processEngine);
        }
    }

    public List<ProcessEnginePlugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + this.plugins;
    }

    private static List<ProcessEnginePlugin> toList(ProcessEnginePlugin plugin, ProcessEnginePlugin ... additionalPlugins) {
        ArrayList<ProcessEnginePlugin> plugins = new ArrayList<ProcessEnginePlugin>();
        plugins.add(plugin);
        if (additionalPlugins != null && additionalPlugins.length > 0) {
            plugins.addAll(Arrays.asList(additionalPlugins));
        }
        return plugins;
    }
}

