/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.bpmn.listener;

import java.util.List;
import org.operaton.bpm.engine.delegate.DelegateExecution;
import org.operaton.bpm.engine.delegate.ExecutionListener;
import org.operaton.bpm.engine.delegate.Expression;
import org.operaton.bpm.engine.delegate.JavaDelegate;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.operaton.bpm.engine.impl.bpmn.delegate.ExecutionListenerInvocation;
import org.operaton.bpm.engine.impl.bpmn.delegate.JavaDelegateInvocation;
import org.operaton.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.util.ClassDelegateUtil;

public class DelegateExpressionExecutionListener
implements ExecutionListener {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionExecutionListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void notify(DelegateExecution execution) throws Exception {
        Object delegate = this.expression.getValue(execution);
        ClassDelegateUtil.applyFieldDeclaration(this.fieldDeclarations, delegate);
        if (delegate instanceof ExecutionListener) {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation((ExecutionListener)delegate, execution));
        } else if (delegate instanceof JavaDelegate) {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)delegate, execution));
        } else {
            throw LOG.resolveDelegateExpressionException(this.expression, ExecutionListener.class, JavaDelegate.class);
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

