/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.bpmn.helper;

import java.util.List;
import org.operaton.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.operaton.bpm.engine.impl.bpmn.parser.EscalationEventDefinition;
import org.operaton.bpm.engine.impl.pvm.PvmActivity;
import org.operaton.bpm.engine.impl.pvm.PvmScope;
import org.operaton.bpm.engine.impl.tree.TreeVisitor;

public class EscalationEventDefinitionFinder
implements TreeVisitor<PvmScope> {
    protected EscalationEventDefinition escalationEventDefinition;
    protected final String escalationCode;
    protected final PvmActivity throwEscalationActivity;

    public EscalationEventDefinitionFinder(String escalationCode, PvmActivity throwEscalationActivity) {
        this.escalationCode = escalationCode;
        this.throwEscalationActivity = throwEscalationActivity;
    }

    @Override
    public void visit(PvmScope scope) {
        List<EscalationEventDefinition> escalationEventDefinitions = scope.getProperties().get(BpmnProperties.ESCALATION_EVENT_DEFINITIONS);
        this.escalationEventDefinition = this.findMatchingEscalationEventDefinition(escalationEventDefinitions);
    }

    protected EscalationEventDefinition findMatchingEscalationEventDefinition(List<EscalationEventDefinition> escalationEventDefinitions) {
        for (EscalationEventDefinition escalationEventDefinition : escalationEventDefinitions) {
            if (!this.isMatchingEscalationCode(escalationEventDefinition) || this.isReThrowingEscalationEventSubprocess(escalationEventDefinition)) continue;
            return escalationEventDefinition;
        }
        return null;
    }

    protected boolean isMatchingEscalationCode(EscalationEventDefinition escalationEventDefinition) {
        String escalationCode = escalationEventDefinition.getEscalationCode();
        return escalationCode == null || escalationCode.equals(this.escalationCode);
    }

    protected boolean isReThrowingEscalationEventSubprocess(EscalationEventDefinition escalationEventDefinition) {
        PvmActivity escalationHandler = escalationEventDefinition.getEscalationHandler();
        return escalationHandler.isSubProcessScope() && escalationHandler.equals(this.throwEscalationActivity.getFlowScope());
    }

    public EscalationEventDefinition getEscalationEventDefinition() {
        return this.escalationEventDefinition;
    }
}

