/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.bpmn.behavior;

import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.operaton.bpm.engine.delegate.DelegateExecution;
import org.operaton.bpm.engine.delegate.Expression;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class MailActivityBehavior
extends AbstractBpmnActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;
    protected Expression to;
    protected Expression from;
    protected Expression cc;
    protected Expression bcc;
    protected Expression subject;
    protected Expression text;
    protected Expression html;
    protected Expression charset;

    @Override
    public void execute(ActivityExecution execution) {
        String toStr = this.getStringFromField(this.to, execution);
        String fromStr = this.getStringFromField(this.from, execution);
        String ccStr = this.getStringFromField(this.cc, execution);
        String bccStr = this.getStringFromField(this.bcc, execution);
        String subjectStr = this.getStringFromField(this.subject, execution);
        String textStr = this.getStringFromField(this.text, execution);
        String htmlStr = this.getStringFromField(this.html, execution);
        String charSetStr = this.getStringFromField(this.charset, execution);
        Email email = this.createEmail(textStr, htmlStr);
        this.addTo(email, toStr);
        this.setFrom(email, fromStr);
        this.addCc(email, ccStr);
        this.addBcc(email, bccStr);
        this.setSubject(email, subjectStr);
        this.setMailServerProperties(email);
        this.setCharset(email, charSetStr);
        try {
            email.send();
        }
        catch (EmailException e) {
            throw LOG.sendingEmailException(toStr, e);
        }
        this.leave(execution);
    }

    protected Email createEmail(String text, String html) {
        if (html != null) {
            return this.createHtmlEmail(text, html);
        }
        if (text != null) {
            return this.createTextOnlyEmail(text);
        }
        throw LOG.emailFormatException();
    }

    protected HtmlEmail createHtmlEmail(String text, String html) {
        HtmlEmail email = new HtmlEmail();
        try {
            email.setHtmlMsg(html);
            if (text != null) {
                email.setTextMsg(text);
            }
            return email;
        }
        catch (EmailException e) {
            throw LOG.emailCreationException("HTML", e);
        }
    }

    protected SimpleEmail createTextOnlyEmail(String text) {
        SimpleEmail email = new SimpleEmail();
        try {
            email.setMsg(text);
            return email;
        }
        catch (EmailException e) {
            throw LOG.emailCreationException("text-only", e);
        }
    }

    protected void addTo(Email email, String to) {
        String[] tos = this.splitAndTrim(to);
        if (tos != null) {
            for (String t : tos) {
                try {
                    email.addTo(t);
                }
                catch (EmailException e) {
                    throw LOG.addRecipientException(t, e);
                }
            }
        } else {
            throw LOG.missingRecipientsException();
        }
    }

    protected void setFrom(Email email, String from) {
        String fromAddress = null;
        fromAddress = from != null ? from : Context.getProcessEngineConfiguration().getMailServerDefaultFrom();
        try {
            email.setFrom(fromAddress);
        }
        catch (EmailException e) {
            throw LOG.addSenderException(from, e);
        }
    }

    protected void addCc(Email email, String cc) {
        String[] ccs = this.splitAndTrim(cc);
        if (ccs != null) {
            for (String c : ccs) {
                try {
                    email.addCc(c);
                }
                catch (EmailException e) {
                    throw LOG.addCcException(c, e);
                }
            }
        }
    }

    protected void addBcc(Email email, String bcc) {
        String[] bccs = this.splitAndTrim(bcc);
        if (bccs != null) {
            for (String b : bccs) {
                try {
                    email.addBcc(b);
                }
                catch (EmailException e) {
                    throw LOG.addBccException(b, e);
                }
            }
        }
    }

    protected void setSubject(Email email, String subject) {
        email.setSubject(subject != null ? subject : "");
    }

    protected void setMailServerProperties(Email email) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        String host = processEngineConfiguration.getMailServerHost();
        EnsureUtil.ensureNotNull("Could not send email: no SMTP host is configured", "host", (Object)host);
        email.setHostName(host);
        int port = processEngineConfiguration.getMailServerPort();
        email.setSmtpPort(port);
        email.setTLS(processEngineConfiguration.getMailServerUseTLS());
        String user = processEngineConfiguration.getMailServerUsername();
        String password = processEngineConfiguration.getMailServerPassword();
        if (user != null && password != null) {
            email.setAuthentication(user, password);
        }
    }

    protected void setCharset(Email email, String charSetStr) {
        if (this.charset != null) {
            email.setCharset(charSetStr);
        }
    }

    protected String[] splitAndTrim(String str) {
        if (str != null) {
            String[] splittedStrings = str.split(",");
            for (int i = 0; i < splittedStrings.length; ++i) {
                splittedStrings[i] = splittedStrings[i].trim();
            }
            return splittedStrings;
        }
        return null;
    }

    protected String getStringFromField(Expression expression, DelegateExecution execution) {
        Object value;
        if (expression != null && (value = expression.getValue(execution)) != null) {
            return value.toString();
        }
        return null;
    }
}

