/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.bpmn.behavior;

import org.operaton.bpm.engine.impl.PriorityProvider;
import org.operaton.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.operaton.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingExternalTaskInstance;
import org.operaton.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.operaton.bpm.engine.impl.pvm.delegate.MigrationObserverBehavior;

public class ExternalTaskActivityBehavior
extends AbstractBpmnActivityBehavior
implements MigrationObserverBehavior {
    protected ParameterValueProvider topicNameValueProvider;
    protected ParameterValueProvider priorityValueProvider;

    public ExternalTaskActivityBehavior(ParameterValueProvider topicName, ParameterValueProvider paramValueProvider) {
        this.topicNameValueProvider = topicName;
        this.priorityValueProvider = paramValueProvider;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        PriorityProvider<ExternalTaskActivityBehavior> provider = Context.getProcessEngineConfiguration().getExternalTaskPriorityProvider();
        long priority = provider.determinePriority(executionEntity, this, null);
        String topic = (String)this.topicNameValueProvider.getValue(executionEntity);
        ExternalTaskEntity.createAndInsert(executionEntity, topic, priority);
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        this.leave(execution);
    }

    public ParameterValueProvider getPriorityValueProvider() {
        return this.priorityValueProvider;
    }

    @Override
    public void migrateScope(ActivityExecution scopeExecution) {
    }

    @Override
    public void onParseMigratingInstance(MigratingInstanceParseContext parseContext, MigratingActivityInstance migratingInstance) {
        ExecutionEntity execution = migratingInstance.resolveRepresentativeExecution();
        for (ExternalTaskEntity task : execution.getExternalTasks()) {
            MigratingExternalTaskInstance migratingTask = new MigratingExternalTaskInstance(task, migratingInstance);
            migratingInstance.addMigratingDependentInstance(migratingTask);
            parseContext.consume(task);
            parseContext.submit(migratingTask);
        }
    }
}

