/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.batch;

import java.util.List;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.batch.BatchQuery;
import org.operaton.bpm.engine.impl.AbstractQuery;
import org.operaton.bpm.engine.impl.BatchQueryProperty;
import org.operaton.bpm.engine.impl.Page;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.persistence.entity.SuspensionState;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class BatchQueryImpl
extends AbstractQuery<BatchQuery, Batch>
implements BatchQuery {
    private static final long serialVersionUID = 1L;
    protected String batchId;
    protected String type;
    protected boolean isTenantIdSet = false;
    protected String[] tenantIds;
    protected SuspensionState suspensionState;

    public BatchQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public BatchQuery batchId(String batchId) {
        EnsureUtil.ensureNotNull("Batch id", (Object)batchId);
        this.batchId = batchId;
        return this;
    }

    public String getBatchId() {
        return this.batchId;
    }

    @Override
    public BatchQuery type(String type) {
        EnsureUtil.ensureNotNull("Type", (Object)type);
        this.type = type;
        return this;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public BatchQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    public String[] getTenantIds() {
        return this.tenantIds;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }

    @Override
    public BatchQuery withoutTenantId() {
        this.tenantIds = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public BatchQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public BatchQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    @Override
    public BatchQuery orderById() {
        return (BatchQuery)this.orderBy(BatchQueryProperty.ID);
    }

    @Override
    public BatchQuery orderByTenantId() {
        return (BatchQuery)this.orderBy(BatchQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getBatchManager().findBatchCountByQueryCriteria(this);
    }

    @Override
    public List<Batch> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getBatchManager().findBatchesByQueryCriteria(this, page);
    }
}

