/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl;

import java.util.List;
import org.operaton.bpm.engine.impl.ModificationBatchConfiguration;
import org.operaton.bpm.engine.impl.ModificationBuilderImpl;
import org.operaton.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.operaton.bpm.engine.impl.batch.BatchJobContext;
import org.operaton.bpm.engine.impl.batch.BatchJobDeclaration;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.operaton.bpm.engine.impl.json.ModificationBatchConfigurationJsonConverter;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.JobEntity;
import org.operaton.bpm.engine.impl.persistence.entity.MessageEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;

public class ModificationBatchJobHandler
extends AbstractBatchJobHandler<ModificationBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("instance-modification");

    @Override
    public String getType() {
        return "instance-modification";
    }

    @Override
    protected void postProcessJob(ModificationBatchConfiguration configuration, JobEntity job, ModificationBatchConfiguration jobConfiguration) {
        if (job.getDeploymentId() == null) {
            CommandContext commandContext = Context.getCommandContext();
            ProcessDefinitionEntity processDefinitionEntity = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(configuration.getProcessDefinitionId());
            job.setDeploymentId(processDefinitionEntity.getDeploymentId());
        }
    }

    @Override
    public void executeHandler(ModificationBatchConfiguration batchConfiguration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        ModificationBuilderImpl executionBuilder = (ModificationBuilderImpl)commandContext.getProcessEngineConfiguration().getRuntimeService().createModification(batchConfiguration.getProcessDefinitionId()).processInstanceIds(batchConfiguration.getIds());
        executionBuilder.setInstructions(batchConfiguration.getInstructions());
        if (batchConfiguration.isSkipCustomListeners()) {
            executionBuilder.skipCustomListeners();
        }
        if (batchConfiguration.isSkipIoMappings()) {
            executionBuilder.skipIoMappings();
        }
        executionBuilder.execute(false);
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected ModificationBatchConfiguration createJobConfiguration(ModificationBatchConfiguration configuration, List<String> processIdsForJob) {
        return new ModificationBatchConfiguration(processIdsForJob, configuration.getProcessDefinitionId(), configuration.getInstructions(), configuration.isSkipCustomListeners(), configuration.isSkipIoMappings());
    }

    protected ModificationBatchConfigurationJsonConverter getJsonConverterInstance() {
        return ModificationBatchConfigurationJsonConverter.INSTANCE;
    }

    protected ProcessDefinitionEntity getProcessDefinition(CommandContext commandContext, String processDefinitionId) {
        return commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId);
    }
}

