/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.operaton.bpm.engine.exception.NotValidException;
import org.operaton.bpm.engine.history.DurationReportResult;
import org.operaton.bpm.engine.history.HistoricProcessInstanceReport;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.db.TenantCheck;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.util.CompareUtil;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.query.PeriodUnit;

public class HistoricProcessInstanceReportImpl
implements HistoricProcessInstanceReport {
    private static final long serialVersionUID = 1L;
    protected Date startedAfter;
    protected Date startedBefore;
    protected String[] processDefinitionIdIn;
    protected String[] processDefinitionKeyIn;
    protected PeriodUnit durationPeriodUnit;
    protected CommandExecutor commandExecutor;
    protected TenantCheck tenantCheck = new TenantCheck();

    public HistoricProcessInstanceReportImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public HistoricProcessInstanceReport startedAfter(Date startedAfter) {
        EnsureUtil.ensureNotNull(NotValidException.class, "startedAfter", (Object)startedAfter);
        this.startedAfter = startedAfter;
        return this;
    }

    @Override
    public HistoricProcessInstanceReport startedBefore(Date startedBefore) {
        EnsureUtil.ensureNotNull(NotValidException.class, "startedBefore", (Object)startedBefore);
        this.startedBefore = startedBefore;
        return this;
    }

    @Override
    public HistoricProcessInstanceReport processDefinitionIdIn(String ... processDefinitionIds) {
        EnsureUtil.ensureNotNull(NotValidException.class, "", "processDefinitionIdIn", (Object[])processDefinitionIds);
        this.processDefinitionIdIn = processDefinitionIds;
        return this;
    }

    @Override
    public HistoricProcessInstanceReport processDefinitionKeyIn(String ... processDefinitionKeys) {
        EnsureUtil.ensureNotNull(NotValidException.class, "", "processDefinitionKeyIn", (Object[])processDefinitionKeys);
        this.processDefinitionKeyIn = processDefinitionKeys;
        return this;
    }

    @Override
    public List<DurationReportResult> duration(PeriodUnit periodUnit) {
        EnsureUtil.ensureNotNull(NotValidException.class, "periodUnit", (Object)periodUnit);
        this.durationPeriodUnit = periodUnit;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return this.commandExecutor.execute(new ExecuteDurationReportCmd());
        }
        return this.executeDurationReport(commandContext);
    }

    public List<DurationReportResult> executeDurationReport(CommandContext commandContext) {
        this.doAuthCheck(commandContext);
        if (CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.startedAfter, this.startedBefore})) {
            return Collections.emptyList();
        }
        return commandContext.getHistoricReportManager().selectHistoricProcessInstanceDurationReport(this);
    }

    protected void doAuthCheck(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            if (this.processDefinitionIdIn == null && this.processDefinitionKeyIn == null) {
                checker.checkReadHistoryAnyProcessDefinition();
                continue;
            }
            ArrayList<String> processDefinitionKeys = new ArrayList<String>();
            if (this.processDefinitionKeyIn != null) {
                processDefinitionKeys.addAll(Arrays.asList(this.processDefinitionKeyIn));
            }
            if (this.processDefinitionIdIn != null) {
                for (String processDefinitionId : this.processDefinitionIdIn) {
                    ProcessDefinitionEntity processDefinition = commandContext.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
                    if (processDefinition == null || processDefinition.getKey() == null) continue;
                    processDefinitionKeys.add(processDefinition.getKey());
                }
            }
            if (processDefinitionKeys.isEmpty()) continue;
            for (String processDefinitionKey : processDefinitionKeys) {
                checker.checkReadHistoryProcessDefinition(processDefinitionKey);
            }
        }
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public String[] getProcessDefinitionIdIn() {
        return this.processDefinitionIdIn;
    }

    public String[] getProcessDefinitionKeyIn() {
        return this.processDefinitionKeyIn;
    }

    public TenantCheck getTenantCheck() {
        return this.tenantCheck;
    }

    public String getReportPeriodUnitName() {
        return this.durationPeriodUnit.name();
    }

    protected class ExecuteDurationReportCmd
    implements Command<List<DurationReportResult>> {
        protected ExecuteDurationReportCmd() {
        }

        @Override
        public List<DurationReportResult> execute(CommandContext commandContext) {
            return HistoricProcessInstanceReportImpl.this.executeDurationReport(commandContext);
        }
    }
}

