/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl;

import java.util.Date;
import java.util.List;
import org.operaton.bpm.engine.exception.NotValidException;
import org.operaton.bpm.engine.history.CleanableHistoricProcessInstanceReport;
import org.operaton.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import org.operaton.bpm.engine.impl.AbstractQuery;
import org.operaton.bpm.engine.impl.CleanableHistoricInstanceReportProperty;
import org.operaton.bpm.engine.impl.Page;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class CleanableHistoricProcessInstanceReportImpl
extends AbstractQuery<CleanableHistoricProcessInstanceReport, CleanableHistoricProcessInstanceReportResult>
implements CleanableHistoricProcessInstanceReport {
    private static final long serialVersionUID = 1L;
    protected String[] processDefinitionIdIn;
    protected String[] processDefinitionKeyIn;
    protected String[] tenantIdIn;
    protected boolean isTenantIdSet = false;
    protected boolean isCompact = false;
    protected Date currentTimestamp;
    protected boolean isHistoryCleanupStrategyRemovalTimeBased;

    public CleanableHistoricProcessInstanceReportImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public CleanableHistoricProcessInstanceReport processDefinitionIdIn(String ... processDefinitionIds) {
        EnsureUtil.ensureNotNull(NotValidException.class, "", "processDefinitionIdIn", (Object[])processDefinitionIds);
        this.processDefinitionIdIn = processDefinitionIds;
        return this;
    }

    @Override
    public CleanableHistoricProcessInstanceReport processDefinitionKeyIn(String ... processDefinitionKeys) {
        EnsureUtil.ensureNotNull(NotValidException.class, "", "processDefinitionKeyIn", (Object[])processDefinitionKeys);
        this.processDefinitionKeyIn = processDefinitionKeys;
        return this;
    }

    @Override
    public CleanableHistoricProcessInstanceReport tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull(NotValidException.class, "", "tenantIdIn", (Object[])tenantIds);
        this.tenantIdIn = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public CleanableHistoricProcessInstanceReport withoutTenantId() {
        this.tenantIdIn = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public CleanableHistoricProcessInstanceReport compact() {
        this.isCompact = true;
        return this;
    }

    @Override
    public CleanableHistoricProcessInstanceReport orderByFinished() {
        this.orderBy(CleanableHistoricInstanceReportProperty.FINISHED_AMOUNT);
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.provideHistoryCleanupStrategy(commandContext);
        this.checkQueryOk();
        return commandContext.getHistoricProcessInstanceManager().findCleanableHistoricProcessInstancesReportCountByCriteria(this);
    }

    @Override
    public List<CleanableHistoricProcessInstanceReportResult> executeList(CommandContext commandContext, Page page) {
        this.provideHistoryCleanupStrategy(commandContext);
        this.checkQueryOk();
        return commandContext.getHistoricProcessInstanceManager().findCleanableHistoricProcessInstancesReportByCriteria(this, page);
    }

    public Date getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    public void setCurrentTimestamp(Date currentTimestamp) {
        this.currentTimestamp = currentTimestamp;
    }

    public String[] getProcessDefinitionIdIn() {
        return this.processDefinitionIdIn;
    }

    public String[] getProcessDefinitionKeyIn() {
        return this.processDefinitionKeyIn;
    }

    public String[] getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(String[] tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }

    public boolean isCompact() {
        return this.isCompact;
    }

    protected void provideHistoryCleanupStrategy(CommandContext commandContext) {
        String historyCleanupStrategy = commandContext.getProcessEngineConfiguration().getHistoryCleanupStrategy();
        this.isHistoryCleanupStrategyRemovalTimeBased = "removalTimeBased".equals(historyCleanupStrategy);
    }

    public boolean isHistoryCleanupStrategyRemovalTimeBased() {
        return this.isHistoryCleanupStrategyRemovalTimeBased;
    }
}

