/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.application.impl;

import java.lang.ref.WeakReference;
import org.operaton.bpm.application.AbstractProcessApplication;
import org.operaton.bpm.application.ProcessApplicationReference;
import org.operaton.bpm.application.ProcessApplicationUnavailableException;
import org.operaton.bpm.application.impl.ProcessApplicationLogger;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;

public class ProcessApplicationReferenceImpl
implements ProcessApplicationReference {
    private static ProcessApplicationLogger LOG = ProcessEngineLogger.PROCESS_APPLICATION_LOGGER;
    protected WeakReference<AbstractProcessApplication> processApplication;
    protected String name;

    public ProcessApplicationReferenceImpl(AbstractProcessApplication processApplication) {
        this.processApplication = new WeakReference<AbstractProcessApplication>(processApplication);
        this.name = processApplication.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractProcessApplication getProcessApplication() throws ProcessApplicationUnavailableException {
        AbstractProcessApplication application = (AbstractProcessApplication)this.processApplication.get();
        if (application == null) {
            throw LOG.processApplicationUnavailableException(this.name);
        }
        return application;
    }

    public void processEngineStopping(ProcessEngine processEngine) throws ProcessApplicationUnavailableException {
    }

    public void clear() {
        this.processApplication.clear();
    }
}

