/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.spring;

import org.operaton.bpm.engine.impl.cfg.TransactionContext;
import org.operaton.bpm.engine.impl.cfg.TransactionListener;
import org.operaton.bpm.engine.impl.cfg.TransactionState;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionContext
implements TransactionContext {
    protected PlatformTransactionManager transactionManager;
    protected CommandContext commandContext;
    protected TransactionState lastTransactionState = null;

    public SpringTransactionContext(PlatformTransactionManager transactionManager, CommandContext commandContext) {
        this.transactionManager = transactionManager;
        this.commandContext = commandContext;
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            @Override
            public void beforeCommit(boolean readOnly) {
                SpringTransactionContext.this.lastTransactionState = TransactionState.COMMITTING;
            }

            @Override
            public void afterCommit() {
                SpringTransactionContext.this.lastTransactionState = TransactionState.COMMITTED;
            }

            @Override
            public void beforeCompletion() {
                SpringTransactionContext.this.lastTransactionState = TransactionState.ROLLINGBACK;
            }

            @Override
            public void afterCompletion(int status) {
                if (1 == status) {
                    SpringTransactionContext.this.lastTransactionState = TransactionState.ROLLED_BACK;
                }
            }
        });
    }

    public void commit() {
    }

    public void rollback() {
        this.transactionManager.getTransaction(null).setRollbackOnly();
    }

    public void addTransactionListener(TransactionState transactionState, final TransactionListener transactionListener) {
        if (transactionState.equals((Object)TransactionState.COMMITTING)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                @Override
                public void beforeCommit(boolean readOnly) {
                    transactionListener.execute(SpringTransactionContext.this.commandContext);
                }
            });
        } else if (transactionState.equals((Object)TransactionState.COMMITTED)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                @Override
                public void afterCommit() {
                    transactionListener.execute(SpringTransactionContext.this.commandContext);
                }
            });
        } else if (transactionState.equals((Object)TransactionState.ROLLINGBACK)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                @Override
                public void beforeCompletion() {
                    transactionListener.execute(SpringTransactionContext.this.commandContext);
                }
            });
        } else if (transactionState.equals((Object)TransactionState.ROLLED_BACK)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                @Override
                public void afterCompletion(int status) {
                    if (1 == status) {
                        transactionListener.execute(SpringTransactionContext.this.commandContext);
                    }
                }
            });
        }
    }

    public boolean isTransactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive() && !TransactionState.ROLLED_BACK.equals((Object)this.lastTransactionState) && !TransactionState.ROLLINGBACK.equals((Object)this.lastTransactionState);
    }

    protected abstract class TransactionSynchronizationAdapter
    implements TransactionSynchronization {
        protected TransactionSynchronizationAdapter() {
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void flush() {
        }

        public void beforeCommit(boolean readOnly) {
        }

        public void beforeCompletion() {
        }

        public void afterCommit() {
        }

        public void afterCompletion(int status) {
        }
    }
}

