/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.impl.validation;

import java.util.Collection;
import org.operaton.bpm.model.xml.impl.ModelInstanceImpl;
import org.operaton.bpm.model.xml.impl.validation.ValidationResultsCollectorImpl;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.validation.ModelElementValidator;
import org.operaton.bpm.model.xml.validation.ValidationResults;

public class ModelInstanceValidator {
    protected ModelInstanceImpl modelInstanceImpl;
    protected Collection<ModelElementValidator<?>> validators;

    public ModelInstanceValidator(ModelInstanceImpl modelInstanceImpl, Collection<ModelElementValidator<?>> validators) {
        this.modelInstanceImpl = modelInstanceImpl;
        this.validators = validators;
    }

    public ValidationResults validate() {
        ValidationResultsCollectorImpl resultsCollector = new ValidationResultsCollectorImpl();
        for (ModelElementValidator<?> validator : this.validators) {
            Class<?> elementType = validator.getElementType();
            Collection<?> modelElementsByType = this.modelInstanceImpl.getModelElementsByType(elementType);
            for (ModelElementInstance element : modelElementsByType) {
                resultsCollector.setCurrentElement(element);
                try {
                    validator.validate(element, resultsCollector);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Validator " + validator + " threw an exception while validating " + element, e);
                }
            }
        }
        return resultsCollector.getResults();
    }
}

