/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.impl.util;

import java.util.HashMap;
import java.util.Map;
import org.operaton.bpm.model.xml.impl.util.QName;
import org.operaton.bpm.model.xml.instance.DomDocument;
import org.operaton.bpm.model.xml.instance.DomElement;

public class XmlQName {
    public static final Map<String, String> KNOWN_PREFIXES = new HashMap<String, String>();
    protected DomElement rootElement;
    protected DomElement element;
    protected String localName;
    protected String namespaceUri;
    protected String prefix;

    public XmlQName(DomDocument document, String namespaceUri, String localName) {
        this(document, null, namespaceUri, localName);
    }

    public XmlQName(DomElement element, String namespaceUri, String localName) {
        this(element.getDocument(), element, namespaceUri, localName);
    }

    public XmlQName(DomDocument document, DomElement element, String namespaceUri, String localName) {
        this.rootElement = document.getRootElement();
        this.element = element;
        this.localName = localName;
        this.namespaceUri = namespaceUri;
        this.prefix = null;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getLocalName() {
        return this.localName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrefixedName() {
        if (this.prefix == null) {
            XmlQName xmlQName = this;
            synchronized (xmlQName) {
                if (this.prefix == null) {
                    this.prefix = this.determinePrefixAndNamespaceUri();
                }
            }
        }
        return QName.combine(this.prefix, this.localName);
    }

    public boolean hasLocalNamespace() {
        if (this.element != null) {
            return this.element.getNamespaceURI().equals(this.namespaceUri);
        }
        return false;
    }

    private String determinePrefixAndNamespaceUri() {
        if (this.namespaceUri != null) {
            if (this.rootElement != null && this.namespaceUri.equals(this.rootElement.getNamespaceURI())) {
                return null;
            }
            String lookupPrefix = this.lookupPrefix();
            if (lookupPrefix == null && this.rootElement != null) {
                String knownPrefix = KNOWN_PREFIXES.get(this.namespaceUri);
                if (knownPrefix == null) {
                    return this.rootElement.registerNamespace(this.namespaceUri);
                }
                if (knownPrefix.isEmpty()) {
                    return null;
                }
                this.rootElement.registerNamespace(knownPrefix, this.namespaceUri);
                return knownPrefix;
            }
            return lookupPrefix;
        }
        return null;
    }

    private String lookupPrefix() {
        if (this.namespaceUri != null) {
            String lookupPrefix = null;
            if (this.element != null) {
                lookupPrefix = this.element.lookupPrefix(this.namespaceUri);
            } else if (this.rootElement != null) {
                lookupPrefix = this.rootElement.lookupPrefix(this.namespaceUri);
            }
            return lookupPrefix;
        }
        return null;
    }

    static {
        KNOWN_PREFIXES.put("http://www.operaton.com/fox", "fox");
        KNOWN_PREFIXES.put("http://activiti.org/bpmn", "operaton");
        KNOWN_PREFIXES.put("http://operaton.org/schema/1.0/bpmn", "operaton");
        KNOWN_PREFIXES.put("http://www.omg.org/spec/BPMN/20100524/MODEL", "bpmn2");
        KNOWN_PREFIXES.put("http://www.omg.org/spec/BPMN/20100524/DI", "bpmndi");
        KNOWN_PREFIXES.put("http://www.omg.org/spec/DD/20100524/DI", "di");
        KNOWN_PREFIXES.put("http://www.omg.org/spec/DD/20100524/DC", "dc");
        KNOWN_PREFIXES.put("http://www.w3.org/2000/xmlns/", "");
    }
}

