/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.impl.type.reference;

import org.operaton.bpm.model.xml.Model;
import org.operaton.bpm.model.xml.ModelException;
import org.operaton.bpm.model.xml.impl.ModelBuildOperation;
import org.operaton.bpm.model.xml.impl.type.ModelElementTypeImpl;
import org.operaton.bpm.model.xml.impl.type.attribute.AttributeImpl;
import org.operaton.bpm.model.xml.impl.type.reference.AttributeReferenceImpl;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.type.reference.AttributeReference;
import org.operaton.bpm.model.xml.type.reference.AttributeReferenceBuilder;

public class AttributeReferenceBuilderImpl<T extends ModelElementInstance>
implements AttributeReferenceBuilder<T>,
ModelBuildOperation {
    private final AttributeImpl<String> referenceSourceAttribute;
    protected AttributeReferenceImpl<T> attributeReferenceImpl;
    private final Class<T> referenceTargetElement;

    public AttributeReferenceBuilderImpl(AttributeImpl<String> referenceSourceAttribute, Class<T> referenceTargetElement) {
        this.referenceSourceAttribute = referenceSourceAttribute;
        this.referenceTargetElement = referenceTargetElement;
        this.attributeReferenceImpl = new AttributeReferenceImpl(referenceSourceAttribute);
    }

    @Override
    public AttributeReference<T> build() {
        this.referenceSourceAttribute.registerOutgoingReference(this.attributeReferenceImpl);
        return this.attributeReferenceImpl;
    }

    @Override
    public void performModelBuild(Model model) {
        ModelElementTypeImpl referenceTargetType = (ModelElementTypeImpl)model.getType(this.referenceTargetElement);
        this.attributeReferenceImpl.setReferenceTargetElementType(referenceTargetType);
        AttributeImpl idAttribute = (AttributeImpl)referenceTargetType.getAttribute("id");
        if (idAttribute == null) {
            throw new ModelException("Element type " + referenceTargetType.getTypeNamespace() + ":" + referenceTargetType.getTypeName() + " has no id attribute");
        }
        idAttribute.registerIncoming(this.attributeReferenceImpl);
        this.attributeReferenceImpl.setReferenceTargetAttribute(idAttribute);
    }
}

