/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.cmmn.impl.instance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.operaton.bpm.model.cmmn.impl.instance.CmmnAttributeElementReferenceCollection;
import org.operaton.bpm.model.cmmn.impl.instance.CmmnElementImpl;
import org.operaton.bpm.model.cmmn.instance.CmmnElement;
import org.operaton.bpm.model.cmmn.instance.EntryCriterion;
import org.operaton.bpm.model.cmmn.instance.ExitCriterion;
import org.operaton.bpm.model.cmmn.instance.ItemControl;
import org.operaton.bpm.model.cmmn.instance.PlanItem;
import org.operaton.bpm.model.cmmn.instance.PlanItemDefinition;
import org.operaton.bpm.model.cmmn.instance.Sentry;
import org.operaton.bpm.model.xml.ModelBuilder;
import org.operaton.bpm.model.xml.impl.instance.ModelTypeInstanceContext;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.type.ModelElementTypeBuilder;
import org.operaton.bpm.model.xml.type.attribute.Attribute;
import org.operaton.bpm.model.xml.type.child.ChildElement;
import org.operaton.bpm.model.xml.type.child.ChildElementCollection;
import org.operaton.bpm.model.xml.type.child.SequenceBuilder;
import org.operaton.bpm.model.xml.type.reference.AttributeReference;
import org.operaton.bpm.model.xml.type.reference.AttributeReferenceCollection;

public class PlanItemImpl
extends CmmnElementImpl
implements PlanItem {
    protected static Attribute<String> nameAttribute;
    protected static AttributeReference<PlanItemDefinition> planItemDefinitionRefAttribute;
    protected static ChildElement<ItemControl> itemControlChild;
    @Deprecated
    protected static AttributeReferenceCollection<Sentry> entryCriteriaRefCollection;
    @Deprecated
    protected static AttributeReferenceCollection<Sentry> exitCriteriaRefCollection;
    protected static ChildElementCollection<EntryCriterion> entryCriterionCollection;
    protected static ChildElementCollection<ExitCriterion> exitCriterionCollection;

    public PlanItemImpl(ModelTypeInstanceContext instanceContext) {
        super(instanceContext);
    }

    @Override
    public String getName() {
        return (String)nameAttribute.getValue((ModelElementInstance)this);
    }

    @Override
    public void setName(String name) {
        nameAttribute.setValue((ModelElementInstance)this, (Object)name);
    }

    @Override
    public PlanItemDefinition getDefinition() {
        return (PlanItemDefinition)planItemDefinitionRefAttribute.getReferenceTargetElement((ModelElementInstance)this);
    }

    @Override
    public void setDefinition(PlanItemDefinition definition) {
        planItemDefinitionRefAttribute.setReferenceTargetElement((ModelElementInstance)this, (ModelElementInstance)definition);
    }

    @Override
    public Collection<Sentry> getEntryCriterias() {
        return entryCriteriaRefCollection.getReferenceTargetElements((ModelElementInstance)this);
    }

    @Override
    public Collection<Sentry> getExitCriterias() {
        return exitCriteriaRefCollection.getReferenceTargetElements((ModelElementInstance)this);
    }

    @Override
    public Collection<Sentry> getEntryCriteria() {
        if (!this.isCmmn11()) {
            return Collections.unmodifiableCollection(this.getEntryCriterias());
        }
        ArrayList<Sentry> sentries = new ArrayList<Sentry>();
        Collection<EntryCriterion> entryCriterions = this.getEntryCriterions();
        for (EntryCriterion entryCriterion : entryCriterions) {
            Sentry sentry = entryCriterion.getSentry();
            if (sentry == null) continue;
            sentries.add(sentry);
        }
        return Collections.unmodifiableCollection(sentries);
    }

    @Override
    public Collection<Sentry> getExitCriteria() {
        if (!this.isCmmn11()) {
            return Collections.unmodifiableCollection(this.getExitCriterias());
        }
        ArrayList<Sentry> sentries = new ArrayList<Sentry>();
        Collection<ExitCriterion> exitCriterions = this.getExitCriterions();
        for (ExitCriterion exitCriterion : exitCriterions) {
            Sentry sentry = exitCriterion.getSentry();
            if (sentry == null) continue;
            sentries.add(sentry);
        }
        return Collections.unmodifiableCollection(sentries);
    }

    @Override
    public Collection<EntryCriterion> getEntryCriterions() {
        return entryCriterionCollection.get((ModelElementInstance)this);
    }

    @Override
    public Collection<ExitCriterion> getExitCriterions() {
        return exitCriterionCollection.get((ModelElementInstance)this);
    }

    @Override
    public ItemControl getItemControl() {
        return (ItemControl)itemControlChild.getChild((ModelElementInstance)this);
    }

    @Override
    public void setItemControl(ItemControl itemControl) {
        itemControlChild.setChild((ModelElementInstance)this, (ModelElementInstance)itemControl);
    }

    public static void registerType(ModelBuilder modelBuilder) {
        ModelElementTypeBuilder typeBuilder = modelBuilder.defineType(PlanItem.class, "planItem").namespaceUri("http://www.omg.org/spec/CMMN/20151109/MODEL").extendsType(CmmnElement.class).instanceProvider((ModelElementTypeBuilder.ModelTypeInstanceProvider)new ModelElementTypeBuilder.ModelTypeInstanceProvider<PlanItem>(){

            public PlanItem newInstance(ModelTypeInstanceContext instanceContext) {
                return new PlanItemImpl(instanceContext);
            }
        });
        nameAttribute = typeBuilder.stringAttribute("name").build();
        planItemDefinitionRefAttribute = typeBuilder.stringAttribute("definitionRef").idAttributeReference(PlanItemDefinition.class).build();
        entryCriteriaRefCollection = typeBuilder.stringAttribute("entryCriteriaRefs").namespace("http://www.omg.org/spec/CMMN/20131201/MODEL").idAttributeReferenceCollection(Sentry.class, CmmnAttributeElementReferenceCollection.class).build();
        exitCriteriaRefCollection = typeBuilder.stringAttribute("exitCriteriaRefs").namespace("http://www.omg.org/spec/CMMN/20131201/MODEL").idAttributeReferenceCollection(Sentry.class, CmmnAttributeElementReferenceCollection.class).build();
        SequenceBuilder sequenceBuilder = typeBuilder.sequence();
        itemControlChild = sequenceBuilder.element(ItemControl.class).build();
        entryCriterionCollection = sequenceBuilder.elementCollection(EntryCriterion.class).build();
        exitCriterionCollection = sequenceBuilder.elementCollection(ExitCriterion.class).build();
        typeBuilder.build();
    }
}

