/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.bpmn.impl.instance;

import java.util.Collection;
import java.util.List;
import org.operaton.bpm.model.bpmn.BpmnModelInstance;
import org.operaton.bpm.model.bpmn.ProcessType;
import org.operaton.bpm.model.bpmn.builder.ProcessBuilder;
import org.operaton.bpm.model.bpmn.impl.instance.CallableElementImpl;
import org.operaton.bpm.model.bpmn.impl.instance.Supports;
import org.operaton.bpm.model.bpmn.instance.Artifact;
import org.operaton.bpm.model.bpmn.instance.Auditing;
import org.operaton.bpm.model.bpmn.instance.CallableElement;
import org.operaton.bpm.model.bpmn.instance.CorrelationSubscription;
import org.operaton.bpm.model.bpmn.instance.FlowElement;
import org.operaton.bpm.model.bpmn.instance.LaneSet;
import org.operaton.bpm.model.bpmn.instance.Monitoring;
import org.operaton.bpm.model.bpmn.instance.Process;
import org.operaton.bpm.model.bpmn.instance.Property;
import org.operaton.bpm.model.bpmn.instance.ResourceRole;
import org.operaton.bpm.model.xml.ModelBuilder;
import org.operaton.bpm.model.xml.impl.instance.ModelElementInstanceImpl;
import org.operaton.bpm.model.xml.impl.instance.ModelTypeInstanceContext;
import org.operaton.bpm.model.xml.impl.util.StringUtil;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.type.ModelElementTypeBuilder;
import org.operaton.bpm.model.xml.type.attribute.Attribute;
import org.operaton.bpm.model.xml.type.child.ChildElement;
import org.operaton.bpm.model.xml.type.child.ChildElementCollection;
import org.operaton.bpm.model.xml.type.child.SequenceBuilder;
import org.operaton.bpm.model.xml.type.reference.ElementReferenceCollection;

public class ProcessImpl
extends CallableElementImpl
implements Process {
    public static final String DEFAULT_HISTORY_TIME_TO_LIVE = "P180D";
    protected static Attribute<ProcessType> processTypeAttribute;
    protected static Attribute<Boolean> isClosedAttribute;
    protected static Attribute<Boolean> isExecutableAttribute;
    protected static ChildElement<Auditing> auditingChild;
    protected static ChildElement<Monitoring> monitoringChild;
    protected static ChildElementCollection<Property> propertyCollection;
    protected static ChildElementCollection<LaneSet> laneSetCollection;
    protected static ChildElementCollection<FlowElement> flowElementCollection;
    protected static ChildElementCollection<Artifact> artifactCollection;
    protected static ChildElementCollection<ResourceRole> resourceRoleCollection;
    protected static ChildElementCollection<CorrelationSubscription> correlationSubscriptionCollection;
    protected static ElementReferenceCollection<Process, Supports> supportsCollection;
    protected static Attribute<String> operatonCandidateStarterGroupsAttribute;
    protected static Attribute<String> operatonCandidateStarterUsersAttribute;
    protected static Attribute<String> operatonJobPriorityAttribute;
    protected static Attribute<String> operatonTaskPriorityAttribute;
    protected static Attribute<String> operatonHistoryTimeToLiveAttribute;
    protected static Attribute<Boolean> operatonIsStartableInTasklistAttribute;
    protected static Attribute<String> operatonVersionTagAttribute;

    public static void registerType(ModelBuilder modelBuilder) {
        ModelElementTypeBuilder typeBuilder = modelBuilder.defineType(Process.class, "process").namespaceUri("http://www.omg.org/spec/BPMN/20100524/MODEL").extendsType(CallableElement.class).instanceProvider((ModelElementTypeBuilder.ModelTypeInstanceProvider)new ModelElementTypeBuilder.ModelTypeInstanceProvider<Process>(){

            public Process newInstance(ModelTypeInstanceContext instanceContext) {
                return new ProcessImpl(instanceContext);
            }
        });
        processTypeAttribute = typeBuilder.enumAttribute("processType", ProcessType.class).defaultValue((Object)ProcessType.None).build();
        isClosedAttribute = typeBuilder.booleanAttribute("isClosed").defaultValue((Object)false).build();
        isExecutableAttribute = typeBuilder.booleanAttribute("isExecutable").build();
        SequenceBuilder sequenceBuilder = typeBuilder.sequence();
        auditingChild = sequenceBuilder.element(Auditing.class).build();
        monitoringChild = sequenceBuilder.element(Monitoring.class).build();
        propertyCollection = sequenceBuilder.elementCollection(Property.class).build();
        laneSetCollection = sequenceBuilder.elementCollection(LaneSet.class).build();
        flowElementCollection = sequenceBuilder.elementCollection(FlowElement.class).build();
        artifactCollection = sequenceBuilder.elementCollection(Artifact.class).build();
        resourceRoleCollection = sequenceBuilder.elementCollection(ResourceRole.class).build();
        correlationSubscriptionCollection = sequenceBuilder.elementCollection(CorrelationSubscription.class).build();
        supportsCollection = sequenceBuilder.elementCollection(Supports.class).qNameElementReferenceCollection(Process.class).build();
        operatonCandidateStarterGroupsAttribute = typeBuilder.stringAttribute("candidateStarterGroups").namespace("http://operaton.org/schema/1.0/bpmn").build();
        operatonCandidateStarterUsersAttribute = typeBuilder.stringAttribute("candidateStarterUsers").namespace("http://operaton.org/schema/1.0/bpmn").build();
        operatonJobPriorityAttribute = typeBuilder.stringAttribute("jobPriority").namespace("http://operaton.org/schema/1.0/bpmn").build();
        operatonTaskPriorityAttribute = typeBuilder.stringAttribute("taskPriority").namespace("http://operaton.org/schema/1.0/bpmn").build();
        operatonHistoryTimeToLiveAttribute = typeBuilder.stringAttribute("historyTimeToLive").namespace("http://operaton.org/schema/1.0/bpmn").build();
        operatonIsStartableInTasklistAttribute = typeBuilder.booleanAttribute("isStartableInTasklist").defaultValue((Object)true).namespace("http://operaton.org/schema/1.0/bpmn").build();
        operatonVersionTagAttribute = typeBuilder.stringAttribute("versionTag").namespace("http://operaton.org/schema/1.0/bpmn").build();
        typeBuilder.build();
    }

    public ProcessImpl(ModelTypeInstanceContext context) {
        super(context);
    }

    @Override
    public ProcessBuilder builder() {
        return new ProcessBuilder((BpmnModelInstance)this.modelInstance, this);
    }

    @Override
    public ProcessType getProcessType() {
        return (ProcessType)((Object)processTypeAttribute.getValue((ModelElementInstance)this));
    }

    @Override
    public void setProcessType(ProcessType processType) {
        processTypeAttribute.setValue((ModelElementInstance)this, (Object)processType);
    }

    @Override
    public boolean isClosed() {
        return (Boolean)isClosedAttribute.getValue((ModelElementInstance)this);
    }

    @Override
    public void setClosed(boolean closed) {
        isClosedAttribute.setValue((ModelElementInstance)this, (Object)closed);
    }

    @Override
    public boolean isExecutable() {
        return (Boolean)isExecutableAttribute.getValue((ModelElementInstance)this);
    }

    @Override
    public void setExecutable(boolean executable) {
        isExecutableAttribute.setValue((ModelElementInstance)this, (Object)executable);
    }

    @Override
    public Auditing getAuditing() {
        return (Auditing)auditingChild.getChild((ModelElementInstance)this);
    }

    @Override
    public void setAuditing(Auditing auditing) {
        auditingChild.setChild((ModelElementInstance)this, (ModelElementInstance)auditing);
    }

    @Override
    public Monitoring getMonitoring() {
        return (Monitoring)monitoringChild.getChild((ModelElementInstance)this);
    }

    @Override
    public void setMonitoring(Monitoring monitoring) {
        monitoringChild.setChild((ModelElementInstance)this, (ModelElementInstance)monitoring);
    }

    @Override
    public Collection<Property> getProperties() {
        return propertyCollection.get((ModelElementInstance)this);
    }

    @Override
    public Collection<LaneSet> getLaneSets() {
        return laneSetCollection.get((ModelElementInstance)this);
    }

    @Override
    public Collection<FlowElement> getFlowElements() {
        return flowElementCollection.get((ModelElementInstance)this);
    }

    @Override
    public Collection<Artifact> getArtifacts() {
        return artifactCollection.get((ModelElementInstance)this);
    }

    @Override
    public Collection<CorrelationSubscription> getCorrelationSubscriptions() {
        return correlationSubscriptionCollection.get((ModelElementInstance)this);
    }

    @Override
    public Collection<ResourceRole> getResourceRoles() {
        return resourceRoleCollection.get((ModelElementInstance)this);
    }

    @Override
    public Collection<Process> getSupports() {
        return supportsCollection.getReferenceTargetElements((ModelElementInstanceImpl)this);
    }

    @Override
    public String getOperatonCandidateStarterGroups() {
        return (String)operatonCandidateStarterGroupsAttribute.getValue((ModelElementInstance)this);
    }

    @Override
    public void setOperatonCandidateStarterGroups(String operatonCandidateStarterGroups) {
        operatonCandidateStarterGroupsAttribute.setValue((ModelElementInstance)this, (Object)operatonCandidateStarterGroups);
    }

    @Override
    public List<String> getOperatonCandidateStarterGroupsList() {
        String groupsString = (String)operatonCandidateStarterGroupsAttribute.getValue((ModelElementInstance)this);
        return StringUtil.splitCommaSeparatedList((String)groupsString);
    }

    @Override
    public void setOperatonCandidateStarterGroupsList(List<String> operatonCandidateStarterGroupsList) {
        String candidateStarterGroups = StringUtil.joinCommaSeparatedList(operatonCandidateStarterGroupsList);
        operatonCandidateStarterGroupsAttribute.setValue((ModelElementInstance)this, (Object)candidateStarterGroups);
    }

    @Override
    public String getOperatonCandidateStarterUsers() {
        return (String)operatonCandidateStarterUsersAttribute.getValue((ModelElementInstance)this);
    }

    @Override
    public void setOperatonCandidateStarterUsers(String operatonCandidateStarterUsers) {
        operatonCandidateStarterUsersAttribute.setValue((ModelElementInstance)this, (Object)operatonCandidateStarterUsers);
    }

    @Override
    public List<String> getOperatonCandidateStarterUsersList() {
        String candidateStarterUsers = (String)operatonCandidateStarterUsersAttribute.getValue((ModelElementInstance)this);
        return StringUtil.splitCommaSeparatedList((String)candidateStarterUsers);
    }

    @Override
    public void setOperatonCandidateStarterUsersList(List<String> operatonCandidateStarterUsersList) {
        String candidateStarterUsers = StringUtil.joinCommaSeparatedList(operatonCandidateStarterUsersList);
        operatonCandidateStarterUsersAttribute.setValue((ModelElementInstance)this, (Object)candidateStarterUsers);
    }

    @Override
    public String getOperatonJobPriority() {
        return (String)operatonJobPriorityAttribute.getValue((ModelElementInstance)this);
    }

    @Override
    public void setOperatonJobPriority(String jobPriority) {
        operatonJobPriorityAttribute.setValue((ModelElementInstance)this, (Object)jobPriority);
    }

    @Override
    public String getOperatonTaskPriority() {
        return (String)operatonTaskPriorityAttribute.getValue((ModelElementInstance)this);
    }

    @Override
    public void setOperatonTaskPriority(String taskPriority) {
        operatonTaskPriorityAttribute.setValue((ModelElementInstance)this, (Object)taskPriority);
    }

    @Override
    public Integer getOperatonHistoryTimeToLive() {
        String ttl = this.getOperatonHistoryTimeToLiveString();
        if (ttl != null) {
            return Integer.parseInt(ttl);
        }
        return null;
    }

    @Override
    public void setOperatonHistoryTimeToLive(Integer historyTimeToLive) {
        String value = historyTimeToLive == null ? null : String.valueOf(historyTimeToLive);
        this.setOperatonHistoryTimeToLiveString(value);
    }

    @Override
    public String getOperatonHistoryTimeToLiveString() {
        return (String)operatonHistoryTimeToLiveAttribute.getValue((ModelElementInstance)this);
    }

    @Override
    public void setOperatonHistoryTimeToLiveString(String historyTimeToLive) {
        if (historyTimeToLive == null) {
            operatonHistoryTimeToLiveAttribute.removeAttribute((ModelElementInstance)this);
        } else {
            operatonHistoryTimeToLiveAttribute.setValue((ModelElementInstance)this, (Object)historyTimeToLive);
        }
    }

    @Override
    public Boolean isOperatonStartableInTasklist() {
        return (Boolean)operatonIsStartableInTasklistAttribute.getValue((ModelElementInstance)this);
    }

    @Override
    public void setOperatonIsStartableInTasklist(Boolean isStartableInTasklist) {
        operatonIsStartableInTasklistAttribute.setValue((ModelElementInstance)this, (Object)isStartableInTasklist);
    }

    @Override
    public String getOperatonVersionTag() {
        return (String)operatonVersionTagAttribute.getValue((ModelElementInstance)this);
    }

    @Override
    public void setOperatonVersionTag(String versionTag) {
        operatonVersionTagAttribute.setValue((ModelElementInstance)this, (Object)versionTag);
    }
}

