/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.bpmn.impl.instance;

import java.util.Collection;
import java.util.HashSet;
import org.operaton.bpm.model.bpmn.BpmnModelException;
import org.operaton.bpm.model.bpmn.Query;
import org.operaton.bpm.model.bpmn.builder.AbstractFlowNodeBuilder;
import org.operaton.bpm.model.bpmn.impl.QueryImpl;
import org.operaton.bpm.model.bpmn.impl.instance.FlowElementImpl;
import org.operaton.bpm.model.bpmn.impl.instance.Incoming;
import org.operaton.bpm.model.bpmn.impl.instance.Outgoing;
import org.operaton.bpm.model.bpmn.instance.FlowElement;
import org.operaton.bpm.model.bpmn.instance.FlowNode;
import org.operaton.bpm.model.bpmn.instance.SequenceFlow;
import org.operaton.bpm.model.xml.ModelBuilder;
import org.operaton.bpm.model.xml.impl.instance.ModelElementInstanceImpl;
import org.operaton.bpm.model.xml.impl.instance.ModelTypeInstanceContext;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.type.ModelElementTypeBuilder;
import org.operaton.bpm.model.xml.type.attribute.Attribute;
import org.operaton.bpm.model.xml.type.child.SequenceBuilder;
import org.operaton.bpm.model.xml.type.reference.AttributeReference;
import org.operaton.bpm.model.xml.type.reference.ElementReferenceCollection;
import org.operaton.bpm.model.xml.type.reference.Reference;

public abstract class FlowNodeImpl
extends FlowElementImpl
implements FlowNode {
    protected static ElementReferenceCollection<SequenceFlow, Incoming> incomingCollection;
    protected static ElementReferenceCollection<SequenceFlow, Outgoing> outgoingCollection;
    protected static Attribute<Boolean> operatonAsyncAfter;
    protected static Attribute<Boolean> operatonAsyncBefore;
    protected static Attribute<Boolean> operatonExclusive;
    protected static Attribute<String> operatonJobPriority;

    public static void registerType(ModelBuilder modelBuilder) {
        ModelElementTypeBuilder typeBuilder = modelBuilder.defineType(FlowNode.class, "flowNode").namespaceUri("http://www.omg.org/spec/BPMN/20100524/MODEL").extendsType(FlowElement.class).abstractType();
        SequenceBuilder sequenceBuilder = typeBuilder.sequence();
        incomingCollection = sequenceBuilder.elementCollection(Incoming.class).qNameElementReferenceCollection(SequenceFlow.class).build();
        outgoingCollection = sequenceBuilder.elementCollection(Outgoing.class).qNameElementReferenceCollection(SequenceFlow.class).build();
        operatonAsyncAfter = typeBuilder.booleanAttribute("asyncAfter").namespace("http://operaton.org/schema/1.0/bpmn").defaultValue((Object)false).build();
        operatonAsyncBefore = typeBuilder.booleanAttribute("asyncBefore").namespace("http://operaton.org/schema/1.0/bpmn").defaultValue((Object)false).build();
        operatonExclusive = typeBuilder.booleanAttribute("exclusive").namespace("http://operaton.org/schema/1.0/bpmn").defaultValue((Object)true).build();
        operatonJobPriority = typeBuilder.stringAttribute("jobPriority").namespace("http://operaton.org/schema/1.0/bpmn").build();
        typeBuilder.build();
    }

    public FlowNodeImpl(ModelTypeInstanceContext context) {
        super(context);
    }

    @Override
    public AbstractFlowNodeBuilder builder() {
        throw new BpmnModelException("No builder implemented for type " + this.getElementType().getTypeNamespace() + ":" + this.getElementType().getTypeName());
    }

    public void updateAfterReplacement() {
        super.updateAfterReplacement();
        Collection<Reference> incomingReferences = this.getIncomingReferencesByType(SequenceFlow.class);
        for (Reference reference : incomingReferences) {
            for (ModelElementInstance sourceElement : reference.findReferenceSourceElements((ModelElementInstance)this)) {
                String referenceIdentifier = reference.getReferenceIdentifier(sourceElement);
                if (referenceIdentifier == null || !referenceIdentifier.equals(this.getId()) || !(reference instanceof AttributeReference)) continue;
                String attributeName = ((AttributeReference)reference).getReferenceSourceAttribute().getAttributeName();
                if (attributeName.equals("sourceRef")) {
                    this.getOutgoing().add((SequenceFlow)sourceElement);
                    continue;
                }
                if (!attributeName.equals("targetRef")) continue;
                this.getIncoming().add((SequenceFlow)sourceElement);
            }
        }
    }

    @Override
    public Collection<SequenceFlow> getIncoming() {
        return incomingCollection.getReferenceTargetElements((ModelElementInstanceImpl)this);
    }

    @Override
    public Collection<SequenceFlow> getOutgoing() {
        return outgoingCollection.getReferenceTargetElements((ModelElementInstanceImpl)this);
    }

    @Override
    public Query<FlowNode> getPreviousNodes() {
        HashSet<FlowNode> previousNodes = new HashSet<FlowNode>();
        for (SequenceFlow sequenceFlow : this.getIncoming()) {
            previousNodes.add(sequenceFlow.getSource());
        }
        return new QueryImpl<FlowNode>(previousNodes);
    }

    @Override
    public Query<FlowNode> getSucceedingNodes() {
        HashSet<FlowNode> succeedingNodes = new HashSet<FlowNode>();
        for (SequenceFlow sequenceFlow : this.getOutgoing()) {
            succeedingNodes.add(sequenceFlow.getTarget());
        }
        return new QueryImpl<FlowNode>(succeedingNodes);
    }

    @Override
    public boolean isOperatonAsyncBefore() {
        return (Boolean)operatonAsyncBefore.getValue((ModelElementInstance)this);
    }

    @Override
    public void setOperatonAsyncBefore(boolean isOperatonAsyncBefore) {
        operatonAsyncBefore.setValue((ModelElementInstance)this, (Object)isOperatonAsyncBefore);
    }

    @Override
    public boolean isOperatonAsyncAfter() {
        return (Boolean)operatonAsyncAfter.getValue((ModelElementInstance)this);
    }

    @Override
    public void setOperatonAsyncAfter(boolean isOperatonAsyncAfter) {
        operatonAsyncAfter.setValue((ModelElementInstance)this, (Object)isOperatonAsyncAfter);
    }

    @Override
    public boolean isOperatonExclusive() {
        return (Boolean)operatonExclusive.getValue((ModelElementInstance)this);
    }

    @Override
    public void setOperatonExclusive(boolean isOperatonExclusive) {
        operatonExclusive.setValue((ModelElementInstance)this, (Object)isOperatonExclusive);
    }

    @Override
    public String getOperatonJobPriority() {
        return (String)operatonJobPriority.getValue((ModelElementInstance)this);
    }

    @Override
    public void setOperatonJobPriority(String jobPriority) {
        operatonJobPriority.setValue((ModelElementInstance)this, (Object)jobPriority);
    }
}

