/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.feel.impl.scala.function;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.camunda.feel.context.JavaFunction;
import org.camunda.feel.context.JavaFunctionProvider;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.valuemapper.ValueMapper;
import org.operaton.bpm.dmn.feel.impl.scala.ScalaFeelLogger;
import org.operaton.bpm.dmn.feel.impl.scala.function.CustomFunction;
import org.operaton.bpm.dmn.feel.impl.scala.function.FeelCustomFunctionProvider;

public class CustomFunctionTransformer
extends JavaFunctionProvider {
    protected static final ScalaFeelLogger LOGGER = ScalaFeelLogger.LOGGER;
    protected Map<String, JavaFunction> functions = new HashMap<String, JavaFunction>();
    protected ValueMapper valueMapper;

    public CustomFunctionTransformer(List<FeelCustomFunctionProvider> functionProviders, ValueMapper valueMapper) {
        this.valueMapper = valueMapper;
        if (functionProviders != null) {
            this.transformFunctions(functionProviders);
        }
    }

    protected void transformFunctions(List<FeelCustomFunctionProvider> functionProviders) {
        functionProviders.forEach(functionProvider -> {
            Collection<String> functionNames = functionProvider.getFunctionNames();
            functionNames.forEach(functionName -> {
                CustomFunction customFunction = functionProvider.resolveFunction((String)functionName).orElseThrow(LOGGER::customFunctionNotFoundException);
                List<String> params = customFunction.getParams();
                Function<List<Val>, Val> function = this.transformFunction(customFunction);
                boolean hasVarargs = customFunction.hasVarargs();
                JavaFunction javaFunction = new JavaFunction(params, function, hasVarargs);
                this.functions.put((String)functionName, javaFunction);
            });
        });
    }

    protected Function<List<Val>, Val> transformFunction(CustomFunction function) {
        return args -> {
            List<Object> unpackedArgs = this.unpackVals((List<Val>)args);
            Function<List<Object>, Object> functionHandler = function.getFunction();
            Object result = functionHandler.apply(unpackedArgs);
            return this.toVal(result);
        };
    }

    protected List<Object> unpackVals(List<Val> args) {
        return args.stream().map(this::unpackVal).collect(Collectors.toList());
    }

    protected Val toVal(Object rawResult) {
        return this.valueMapper.toVal(rawResult);
    }

    protected Object unpackVal(Val arg) {
        return this.valueMapper.unpackVal(arg);
    }

    public Optional<JavaFunction> resolveFunction(String functionName) {
        return Optional.ofNullable(this.functions.get(functionName));
    }

    public Collection<String> getFunctionNames() {
        return this.functions.keySet();
    }
}

