/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.crypto;

import com.goterl.lazysodium.LazySodium;
import com.goterl.lazysodium.utils.Key;
import com.goterl.lazysodium.utils.KeyPair;
import com.goterl.lazysodium.utils.SessionPair;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openziti.crypto.CryptoLoader;
import org.openziti.crypto.JavaCryptoLoader;
import org.openziti.crypto.StreamImpl;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/openziti/crypto/Crypto;", "", "()V", "sodium", "Lcom/goterl/lazysodium/LazySodium;", "getSodium$ziti", "()Lcom/goterl/lazysodium/LazySodium;", "kx", "Lcom/goterl/lazysodium/utils/SessionPair;", "pair", "Lcom/goterl/lazysodium/utils/KeyPair;", "peerPub", "Lcom/goterl/lazysodium/utils/Key;", "server", "", "newKeyPair", "newStream", "Lorg/openziti/crypto/Crypto$SecretStream;", "SecretStream", "ziti"})
public final class Crypto {
    @NotNull
    public static final Crypto INSTANCE = new Crypto();
    @NotNull
    private static final LazySodium sodium;

    private Crypto() {
    }

    @NotNull
    public final LazySodium getSodium$ziti() {
        return sodium;
    }

    @NotNull
    public final KeyPair newKeyPair() {
        KeyPair keyPair = sodium.cryptoKxKeypair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"sodium.cryptoKxKeypair()");
        return keyPair;
    }

    @NotNull
    public final SessionPair kx(@NotNull KeyPair pair, @NotNull Key peerPub, boolean server) {
        SessionPair sessionPair;
        Intrinsics.checkNotNullParameter((Object)pair, (String)"pair");
        Intrinsics.checkNotNullParameter((Object)peerPub, (String)"peerPub");
        if (server) {
            SessionPair sessionPair2 = sodium.cryptoKxServerSessionKeys(pair.getPublicKey(), pair.getSecretKey(), peerPub);
            sessionPair = sessionPair2;
            Intrinsics.checkNotNullExpressionValue((Object)sessionPair2, (String)"sodium.cryptoKxServerSes\u2026 pair.secretKey, peerPub)");
        } else {
            SessionPair sessionPair3 = sodium.cryptoKxClientSessionKeys(pair.getPublicKey(), pair.getSecretKey(), peerPub);
            sessionPair = sessionPair3;
            Intrinsics.checkNotNullExpressionValue((Object)sessionPair3, (String)"sodium.cryptoKxClientSes\u2026 pair.secretKey, peerPub)");
        }
        return sessionPair;
    }

    @NotNull
    public final SecretStream newStream(@NotNull SessionPair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"pair");
        return new StreamImpl(pair);
    }

    static {
        ServiceLoader<CryptoLoader> sl = ServiceLoader.load(CryptoLoader.class);
        Intrinsics.checkNotNullExpressionValue(sl, (String)"sl");
        CryptoLoader cryptoLoader = (CryptoLoader)CollectionsKt.firstOrNull((Iterable)sl);
        if (cryptoLoader == null) {
            cryptoLoader = new JavaCryptoLoader();
        }
        CryptoLoader ld = cryptoLoader;
        sodium = ld.load();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0006\u001a\u00020\u0003H&J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H&J\b\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lorg/openziti/crypto/Crypto$SecretStream;", "", "decrypt", "", "b", "encrypt", "header", "init", "", "peerHeader", "initialized", "", "ziti"})
    public static interface SecretStream {
        @NotNull
        public byte[] header();

        public void init(@NotNull byte[] var1);

        public boolean initialized();

        @NotNull
        public byte[] encrypt(@NotNull byte[] var1);

        @NotNull
        public byte[] decrypt(@NotNull byte[] var1);
    }
}

