/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.dns;

import java.io.Writer;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.bouncycastle.util.IPAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.net.dns.DNSResolver;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020\u0014H\u0016J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0013H\u0002J\u0015\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b)J\r\u0010*\u001a\u00020 H\u0000\u00a2\u0006\u0002\b+J\u0012\u0010,\u001a\u0004\u0018\u00010\u00142\u0006\u0010(\u001a\u00020\u0013H\u0016J\u001c\u0010-\u001a\u00020 2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020 0/H\u0016J\u0016\u0010-\u001a\u00020 2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e00H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00130\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/openziti/net/dns/ZitiDNSManager;", "Lorg/openziti/net/dns/DNSResolver;", "Lkotlinx/coroutines/CoroutineScope;", "()V", "PREFIX", "", "getPREFIX$ziti", "()[B", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "dnsBroadCast", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lorg/openziti/net/dns/DNSResolver$DNSEvent;", "getDnsBroadCast$ziti", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "host2Ip", "", "", "Ljava/net/InetAddress;", "getHost2Ip$ziti", "()Ljava/util/Map;", "ip2host", "getIp2host$ziti", "postfix", "Ljava/util/concurrent/atomic/AtomicInteger;", "getPostfix$ziti", "()Ljava/util/concurrent/atomic/AtomicInteger;", "startPostfix", "", "dump", "", "writer", "Ljava/io/Writer;", "lookup", "addr", "nextAddr", "dnsname", "registerHostname", "hostname", "registerHostname$ziti", "reset", "reset$ziti", "resolve", "subscribe", "sub", "Lkotlin/Function1;", "Ljava/util/function/Consumer;", "ziti"})
public final class ZitiDNSManager
implements DNSResolver,
CoroutineScope {
    @NotNull
    public static final ZitiDNSManager INSTANCE = new ZitiDNSManager();
    @NotNull
    private static final CoroutineContext coroutineContext = SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getIO());
    @NotNull
    private static final byte[] PREFIX;
    public static final int startPostfix = 257;
    @NotNull
    private static final AtomicInteger postfix;
    @NotNull
    private static final Map<String, InetAddress> host2Ip;
    @NotNull
    private static final Map<InetAddress, String> ip2host;
    @NotNull
    private static final MutableSharedFlow<DNSResolver.DNSEvent> dnsBroadCast;

    private ZitiDNSManager() {
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return coroutineContext;
    }

    @NotNull
    public final byte[] getPREFIX$ziti() {
        return PREFIX;
    }

    @NotNull
    public final AtomicInteger getPostfix$ziti() {
        return postfix;
    }

    @NotNull
    public final Map<String, InetAddress> getHost2Ip$ziti() {
        return host2Ip;
    }

    @NotNull
    public final Map<InetAddress, String> getIp2host$ziti() {
        return ip2host;
    }

    @NotNull
    public final MutableSharedFlow<DNSResolver.DNSEvent> getDnsBroadCast$ziti() {
        return dnsBroadCast;
    }

    @NotNull
    public final InetAddress registerHostname$ziti(@NotNull String hostname) {
        InetAddress inetAddress;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        if (IPAddress.isValidIPv4((String)hostname)) {
            inetAddress = Inet4Address.getByName(hostname);
        } else if (IPAddress.isValidIPv6((String)hostname)) {
            inetAddress = Inet6Address.getByName(hostname);
        } else {
            InetAddress inetAddress2;
            Map<String, InetAddress> $this$getOrPut$iv = host2Ip;
            boolean $i$f$getOrPut = false;
            InetAddress value$iv = $this$getOrPut$iv.get(hostname);
            if (value$iv == null) {
                boolean bl = false;
                InetAddress answer$iv = INSTANCE.nextAddr(hostname);
                $this$getOrPut$iv.put(hostname, answer$iv);
                inetAddress2 = answer$iv;
            } else {
                inetAddress2 = value$iv;
            }
            InetAddress inetAddress3 = inetAddress2;
            boolean bl = false;
            boolean bl2 = false;
            InetAddress it = inetAddress3;
            boolean bl3 = false;
            Map<InetAddress, String> map = INSTANCE.getIp2host$ziti();
            boolean bl4 = false;
            map.put(it, hostname);
            inetAddress = inetAddress3;
        }
        InetAddress ip = inetAddress;
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(hostname, ip, null){
            int label;
            final /* synthetic */ String $hostname;
            final /* synthetic */ InetAddress $ip;
            {
                this.$hostname = $hostname;
                this.$ip = $ip;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        MutableSharedFlow<DNSResolver.DNSEvent> mutableSharedFlow = ZitiDNSManager.INSTANCE.getDnsBroadCast$ziti();
                        InetAddress inetAddress = this.$ip;
                        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"ip");
                        this.label = 1;
                        Object object3 = mutableSharedFlow.emit((Object)new DNSResolver.DNSEvent(this.$hostname, inetAddress, false), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        Intrinsics.checkNotNullExpressionValue((Object)ip, (String)"ip");
        return ip;
    }

    @Override
    @Nullable
    public InetAddress resolve(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        String string = hostname;
        boolean bl = false;
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        return host2Ip.get(string2);
    }

    @Override
    @Nullable
    public String lookup(@NotNull InetAddress addr) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        String string = ip2host.get(addr);
        return string == null ? addr.getHostAddress() : string;
    }

    @Override
    public void subscribe(@NotNull Function1<? super DNSResolver.DNSEvent, Unit> sub) {
        Intrinsics.checkNotNullParameter(sub, (String)"sub");
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sub, null){
            int label;
            final /* synthetic */ Function1<DNSResolver.DNSEvent, Unit> $sub;
            {
                this.$sub = $sub;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$collect$iv;
                        Flow $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Map<String, InetAddress> map = ZitiDNSManager.INSTANCE.getHost2Ip$ziti();
                        Function1<DNSResolver.DNSEvent, Unit> function1 = this.$sub;
                        boolean $i$f$forEach = false;
                        void var5_7 = $this$forEach$iv;
                        boolean bl = false;
                        Iterator<Map.Entry<K, V>> iterator = var5_7.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> $dstr$h$ip = element$iv = iterator.next();
                            boolean bl2 = false;
                            Map.Entry<K, V> entry = $dstr$h$ip;
                            boolean bl3 = false;
                            String h = (String)entry.getKey();
                            Map.Entry<K, V> entry2 = $dstr$h$ip;
                            boolean bl4 = false;
                            InetAddress ip = (InetAddress)entry2.getValue();
                            function1.invoke((Object)new DNSResolver.DNSEvent(h, ip, false));
                        }
                        $this$forEach$iv = (Flow)ZitiDNSManager.INSTANCE.getDnsBroadCast$ziti();
                        function1 = this.$sub;
                        boolean $i$f$collect = false;
                        this.label = 1;
                        Object object3 = $this$collect$iv.collect((FlowCollector)new FlowCollector<DNSResolver.DNSEvent>(function1){
                            final /* synthetic */ Function1 $sub$inlined;
                            {
                                this.$sub$inlined = function1;
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            @Nullable
                            public Object emit(Object value, @NotNull Continuation $completion) {
                                Continuation continuation = $completion;
                                DNSResolver.DNSEvent it = (DNSResolver.DNSEvent)value;
                                boolean bl = false;
                                Object object = this.$sub$inlined.invoke((Object)it);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$collect = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void subscribe(@NotNull Consumer<DNSResolver.DNSEvent> sub) {
        Intrinsics.checkNotNullParameter(sub, (String)"sub");
        this.subscribe((Function1<? super DNSResolver.DNSEvent, Unit>)((Function1)new Function1<DNSResolver.DNSEvent, Unit>(sub){
            final /* synthetic */ Consumer<DNSResolver.DNSEvent> $sub;
            {
                this.$sub = $sub;
                super(1);
            }

            public final void invoke(@NotNull DNSResolver.DNSEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$sub.accept(it);
            }
        }));
    }

    private final InetAddress nextAddr(String dnsname) {
        int nextPostfix = postfix.incrementAndGet();
        if ((nextPostfix & 0xFF) == 0) {
            nextPostfix = postfix.incrementAndGet();
        }
        Object object = new byte[]{(byte)(nextPostfix >> 8 & 0xFF), (byte)(nextPostfix & 0xFF)};
        byte[] ip = ArraysKt.plus((byte[])PREFIX, (byte[])object);
        object = InetAddress.getByAddress(dnsname, ip);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByAddress(dnsname, ip)");
        return object;
    }

    public final void reset$ziti() {
        host2Ip.clear();
        ip2host.clear();
        postfix.set(257);
    }

    @Override
    public void dump(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Object object = host2Ip;
        boolean bl = false;
        Iterator<Map.Entry<String, InetAddress>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Appendable appendable;
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String h = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            InetAddress ip = (InetAddress)object3.getValue();
            object3 = writer;
            CharSequence charSequence = h + " -> " + ip;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)object3.append(charSequence), (String)"append(value)");
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
        }
    }

    static {
        byte[] byArray = new byte[]{100, 64};
        PREFIX = byArray;
        postfix = new AtomicInteger(257);
        boolean bl = false;
        host2Ip = new LinkedHashMap();
        bl = false;
        ip2host = new LinkedHashMap();
        dnsBroadCast = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
    }
}

