/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.util.Logged;
import org.openziti.util.ZitiLog;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\u0018\u0000 O2\u00020\u00012\u00020\u0002:\u0003OPQB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fB\u0015\u0012\u0006\u0010\r\u001a\u00020\u0004\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0011\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u000bH\u0096\u0001J\u001b\u0010!\u001a\u00020\u001e2\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020\u000b0#j\u0002`$H\u0096\u0001J\u0011\u0010%\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u000bH\u0096\u0001J\u0019\u0010%\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0096\u0001J%\u0010%\u001a\u00020\u001e2\b\u0010(\u001a\u0004\u0018\u00010'2\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020\u000b0#j\u0002`$H\u0096\u0001J\u001b\u0010%\u001a\u00020\u001e2\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020\u000b0#j\u0002`$H\u0096\u0001J\b\u0010)\u001a\u00020*H\u0016J\u0013\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0,H\u0016\u00a2\u0006\u0002\u0010-J\u0013\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000b0,H\u0016\u00a2\u0006\u0002\u0010-J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020*H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\bH\u0016J\u0013\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0,H\u0016\u00a2\u0006\u0002\u0010-J\u0013\u00108\u001a\b\u0012\u0004\u0012\u00020\u000b0,H\u0016\u00a2\u0006\u0002\u0010-J\b\u00109\u001a\u00020*H\u0016J\b\u0010:\u001a\u00020*H\u0016J\u0011\u0010;\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u000bH\u0096\u0001J\u001b\u0010;\u001a\u00020\u001e2\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020\u000b0#j\u0002`$H\u0096\u0001J\u0012\u0010<\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020*H\u0016J\u001f\u0010?\u001a\u00020\u001e2\u0010\u0010@\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010,H\u0016\u00a2\u0006\u0002\u0010AJ\u001f\u0010B\u001a\u00020\u001e2\u0010\u0010C\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010,H\u0016\u00a2\u0006\u0002\u0010AJ\u0010\u0010D\u001a\u00020\u001e2\u0006\u0010E\u001a\u00020*H\u0016J\u0010\u0010F\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020\bH\u0016J\u0010\u0010H\u001a\u00020\u001e2\u0006\u0010I\u001a\u00020*H\u0016J\u0010\u0010J\u001a\u00020\u001e2\u0006\u0010K\u001a\u00020*H\u0016J\b\u0010L\u001a\u00020\u001eH\u0016J\u0011\u0010&\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u000bH\u0096\u0001J\u001b\u0010&\u001a\u00020\u001e2\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020\u000b0#j\u0002`$H\u0096\u0001J\u0011\u0010M\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u000bH\u0096\u0001J\u001b\u0010M\u001a\u00020\u001e2\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020\u000b0#j\u0002`$H\u0096\u0001J\u0011\u0010N\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u000bH\u0096\u0001J\u001b\u0010N\u001a\u00020\u001e2\u0010\u0010\"\u001a\f\u0012\u0004\u0012\u00020\u000b0#j\u0002`$H\u0096\u0001R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00060\u0014R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0015\u0010\u0017\u001a\u00060\u0018R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006R"}, d2={"Lorg/openziti/net/internal/ZitiSSLSocket;", "Ljavax/net/ssl/SSLSocket;", "Lorg/openziti/util/Logged;", "s", "Ljava/net/Socket;", "addr", "Ljava/net/InetAddress;", "port", "", "(Ljava/net/Socket;Ljava/net/InetAddress;I)V", "host", "", "(Ljava/net/Socket;Ljava/lang/String;I)V", "transport", "engine", "Ljavax/net/ssl/SSLEngine;", "(Ljava/net/Socket;Ljavax/net/ssl/SSLEngine;)V", "getEngine", "()Ljavax/net/ssl/SSLEngine;", "input", "Lorg/openziti/net/internal/ZitiSSLSocket$Input;", "getInput", "()Lorg/openziti/net/internal/ZitiSSLSocket$Input;", "output", "Lorg/openziti/net/internal/ZitiSSLSocket$Output;", "getOutput", "()Lorg/openziti/net/internal/ZitiSSLSocket$Output;", "getTransport", "()Ljava/net/Socket;", "addHandshakeCompletedListener", "", "listener", "Ljavax/net/ssl/HandshakeCompletedListener;", "d", "msg", "Lkotlin/Function0;", "Lorg/openziti/util/LogMsg;", "e", "t", "", "ex", "getEnableSessionCreation", "", "getEnabledCipherSuites", "", "()[Ljava/lang/String;", "getEnabledProtocols", "getInputStream", "Ljava/io/InputStream;", "getNeedClientAuth", "getOutputStream", "Ljava/io/OutputStream;", "getSession", "Ljavax/net/ssl/SSLSession;", "getSoTimeout", "getSupportedCipherSuites", "getSupportedProtocols", "getUseClientMode", "getWantClientAuth", "i", "removeHandshakeCompletedListener", "setEnableSessionCreation", "flag", "setEnabledCipherSuites", "suites", "([Ljava/lang/String;)V", "setEnabledProtocols", "protocols", "setNeedClientAuth", "need", "setSoTimeout", "timeout", "setUseClientMode", "mode", "setWantClientAuth", "want", "startHandshake", "v", "w", "Companion", "Input", "Output", "ziti"})
public final class ZitiSSLSocket
extends SSLSocket
implements Logged {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Socket transport;
    @NotNull
    private final SSLEngine engine;
    private final /* synthetic */ ZitiLog $$delegate_0;
    @NotNull
    private final Output output;
    @NotNull
    private final Input input;
    private static final TrustManagerFactory tmf;
    private static final SSLContext tls;

    public ZitiSSLSocket(@NotNull Socket transport, @NotNull SSLEngine engine) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this.transport = transport;
        this.engine = engine;
        this.$$delegate_0 = new ZitiLog("ziti-ssl-socket", null, 2, null);
        this.output = new Output();
        this.input = new Input();
        this.engine.setUseClientMode(true);
    }

    @NotNull
    public final Socket getTransport() {
        return this.transport;
    }

    @NotNull
    public final SSLEngine getEngine() {
        return this.engine;
    }

    @Override
    public void d(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.d(msg2);
    }

    @Override
    public void d(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.d(msg2);
    }

    @Override
    public void e(@Nullable Throwable ex, @NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.e(ex, msg2);
    }

    @Override
    public void e(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.e(msg2);
    }

    @Override
    public void e(@NotNull String msg2, @NotNull Throwable t2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
        this.$$delegate_0.e(msg2, t2);
    }

    @Override
    public void e(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.e(msg2);
    }

    @Override
    public void i(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.i(msg2);
    }

    @Override
    public void i(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.i(msg2);
    }

    @Override
    public void t(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.t(msg2);
    }

    @Override
    public void t(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.t(msg2);
    }

    @Override
    public void v(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.v(msg2);
    }

    @Override
    public void v(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.v(msg2);
    }

    @Override
    public void w(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.w(msg2);
    }

    @Override
    public void w(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.w(msg2);
    }

    public ZitiSSLSocket(@NotNull Socket s, @NotNull InetAddress addr, int port) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        String string = addr.getHostName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"addr.hostName");
        this(s, string, port);
    }

    public ZitiSSLSocket(@NotNull Socket s, @NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        SSLEngine sSLEngine = tls.createSSLEngine(host, port);
        Intrinsics.checkNotNullExpressionValue((Object)sSLEngine, (String)"tls.createSSLEngine(host, port)");
        this(s, sSLEngine);
    }

    @NotNull
    public final Output getOutput() {
        return this.output;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return this.output;
    }

    @NotNull
    public final Input getInput() {
        return this.input;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return this.input;
    }

    @Override
    public void startHandshake() {
        this.engine.beginHandshake();
    }

    @Override
    @NotNull
    public SSLSession getSession() {
        Object object;
        ByteBuffer empty = ByteBuffer.wrap(new byte[0]);
        ByteBuffer unwrapped = ByteBuffer.allocate(32768);
        byte[] ssl_in = new byte[32768];
        int read2 = 0;
        int processed = 0;
        block6: while (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.d(Intrinsics.stringPlus((String)"continuing handshake status=", (Object)((Object)this.engine.getHandshakeStatus())));
            object = this.engine.getHandshakeStatus();
            int n = object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
            switch (n) {
                case 1: {
                    Object wrapped = ByteBuffer.allocate(32768);
                    SSLEngineResult res2 = this.engine.wrap(empty, (ByteBuffer)wrapped);
                    this.d(Intrinsics.stringPlus((String)"res = ", (Object)res2));
                    OutputStream outputStream = this.transport.getOutputStream();
                    boolean bl = false;
                    boolean bl2 = false;
                    OutputStream $this$getSession_u24lambda_u2d0 = outputStream;
                    boolean bl3 = false;
                    $this$getSession_u24lambda_u2d0.write(((ByteBuffer)wrapped).array(), 0, res2.bytesProduced());
                    $this$getSession_u24lambda_u2d0.flush();
                    continue block6;
                }
                case 2: {
                    Object wrapped = this.engine.getDelegatedTask();
                    if (wrapped == null) continue block6;
                    wrapped.run();
                    continue block6;
                }
                case 3: {
                    SSLEngineResult res = null;
                    this.v("unwrapping bytes " + processed + ".." + read2);
                    SSLEngineResult res2 = this.engine.unwrap(ByteBuffer.wrap(ssl_in, processed, read2 - processed), unwrapped);
                    Intrinsics.checkNotNullExpressionValue((Object)res2, (String)"engine.unwrap(ByteBuffer.wrap(ssl_in, processed, read - processed), unwrapped)");
                    res = res2;
                    this.v(Intrinsics.stringPlus((String)"res = ", (Object)res));
                    processed += res.bytesConsumed();
                    if (res.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue block6;
                    int r = this.transport.getInputStream().read(ssl_in, read2, ssl_in.length - read2);
                    if (r > 0) {
                        read2 += r;
                    }
                    this.v("read " + r + '/' + read2);
                    continue block6;
                }
                case 4: {
                    SSLSession sSLSession = this.engine.getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)sSLSession, (String)"engine.session");
                    return sSLSession;
                }
            }
        }
        object = this.engine.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"engine.session");
        return object;
    }

    @Override
    public int getSoTimeout() {
        return this.transport.getSoTimeout();
    }

    @Override
    public void setSoTimeout(int timeout) {
        this.transport.setSoTimeout(timeout);
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.engine.setUseClientMode(mode);
    }

    @Override
    public void setEnabledProtocols(@Nullable String[] protocols) {
        this.engine.setEnabledProtocols(protocols);
    }

    @Override
    public void setEnabledCipherSuites(@Nullable String[] suites) {
        this.engine.setEnabledCipherSuites(suites);
    }

    @Override
    public boolean getUseClientMode() {
        return this.engine.getUseClientMode();
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.engine.getEnableSessionCreation();
    }

    @Override
    @NotNull
    public String[] getEnabledProtocols() {
        String[] stringArray = this.engine.getEnabledProtocols();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"engine.enabledProtocols");
        return stringArray;
    }

    @Override
    public boolean getWantClientAuth() {
        return this.engine.getWantClientAuth();
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.engine.getNeedClientAuth();
    }

    @Override
    @NotNull
    public String[] getEnabledCipherSuites() {
        String[] stringArray = this.engine.getEnabledCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"engine.enabledCipherSuites");
        return stringArray;
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.engine.setNeedClientAuth(need);
    }

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        String[] stringArray = this.engine.getSupportedCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"engine.supportedCipherSuites");
        return stringArray;
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.engine.setWantClientAuth(want);
    }

    @Override
    @NotNull
    public String[] getSupportedProtocols() {
        String[] stringArray = this.engine.getSupportedProtocols();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"engine.supportedProtocols");
        return stringArray;
    }

    @Override
    public void addHandshakeCompletedListener(@Nullable HandshakeCompletedListener listener) {
        String string = "not implemented";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    public void removeHandshakeCompletedListener(@Nullable HandshakeCompletedListener listener) {
        String string = "not implemented";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.engine.setEnableSessionCreation(flag);
    }

    static {
        Object object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        boolean bl = false;
        boolean bl2 = false;
        TrustManagerFactory $this$tmf_u24lambda_u2d1 = object;
        boolean bl3 = false;
        $this$tmf_u24lambda_u2d1.init((KeyStore)null);
        tmf = object;
        object = SSLContext.getDefault();
        bl = false;
        bl2 = false;
        Object $this$tls_u24lambda_u2d2 = object;
        boolean bl4 = false;
        ((SSLContext)$this$tls_u24lambda_u2d2).init(null, tmf.getTrustManagers(), new SecureRandom());
        tls = object;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/openziti/net/internal/ZitiSSLSocket$Companion;", "", "()V", "tls", "Ljavax/net/ssl/SSLContext;", "kotlin.jvm.PlatformType", "getTls", "()Ljavax/net/ssl/SSLContext;", "tmf", "Ljavax/net/ssl/TrustManagerFactory;", "getTmf", "()Ljavax/net/ssl/TrustManagerFactory;", "ziti"})
    public static final class Companion {
        private Companion() {
        }

        public final TrustManagerFactory getTmf() {
            return tmf;
        }

        public final SSLContext getTls() {
            return tls;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/openziti/net/internal/ZitiSSLSocket$Output;", "Ljava/io/OutputStream;", "(Lorg/openziti/net/internal/ZitiSSLSocket;)V", "buffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "getBuffer", "()Ljava/nio/ByteBuffer;", "flush", "", "write", "b", "", "off", "", "len", "ziti"})
    public final class Output
    extends OutputStream {
        private final ByteBuffer buffer;

        public Output() {
            Intrinsics.checkNotNullParameter((Object)ZitiSSLSocket.this, (String)"this$0");
            this.buffer = ByteBuffer.allocate(32768);
        }

        public final ByteBuffer getBuffer() {
            return this.buffer;
        }

        @Override
        public void write(int b) {
            this.buffer.put((byte)b);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            ZitiSSLSocket.this.d((Function0<String>)((Function0)new Function0<String>(len){
                final /* synthetic */ int $len;
                {
                    this.$len = $len;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "writing " + this.$len + " bytes";
                }
            }));
            if (len + this.buffer.position() > this.buffer.capacity()) {
                this.flush();
            }
            this.buffer.put(b, off, len);
        }

        @Override
        public void flush() {
            ByteBuffer wrapped = ByteBuffer.allocate(32768);
            this.buffer.flip();
            if (this.buffer.hasRemaining()) {
                SSLEngineResult res = ZitiSSLSocket.this.getEngine().wrap(this.buffer, wrapped);
                ZitiSSLSocket.this.d((Function0<String>)((Function0)new Function0<String>(res){
                    final /* synthetic */ SSLEngineResult $res;
                    {
                        this.$res = $res;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "flushing " + this.$res.bytesProduced() + " bytes";
                    }
                }));
                OutputStream outputStream = ZitiSSLSocket.this.getTransport().getOutputStream();
                if (outputStream != null) {
                    OutputStream outputStream2 = outputStream;
                    boolean bl = false;
                    boolean bl2 = false;
                    OutputStream $this$flush_u24lambda_u2d0 = outputStream2;
                    boolean bl3 = false;
                    $this$flush_u24lambda_u2d0.write(wrapped.array(), 0, wrapped.position());
                    $this$flush_u24lambda_u2d0.flush();
                }
            }
            this.buffer.clear();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u0019\u0010\u0003\u001a\n \u0004*\u0004\u0018\u00010\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \u0004*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/openziti/net/internal/ZitiSSLSocket$Input;", "Ljava/io/InputStream;", "(Lorg/openziti/net/internal/ZitiSSLSocket;)V", "input", "kotlin.jvm.PlatformType", "getInput", "()Ljava/io/InputStream;", "sslBuffer", "Ljava/nio/ByteBuffer;", "getSslBuffer", "()Ljava/nio/ByteBuffer;", "read", "", "out", "", "off", "len", "ziti"})
    public final class Input
    extends InputStream {
        private final ByteBuffer sslBuffer;
        private final InputStream input;

        public Input() {
            Intrinsics.checkNotNullParameter((Object)ZitiSSLSocket.this, (String)"this$0");
            this.sslBuffer = ByteBuffer.allocate(32768);
            this.input = ZitiSSLSocket.this.getTransport().getInputStream();
        }

        public final ByteBuffer getSslBuffer() {
            return this.sslBuffer;
        }

        public final InputStream getInput() {
            return this.input;
        }

        @Override
        public int read() {
            byte[] buf = new byte[1];
            int read2 = this.read(buf, 0, 1);
            return read2 == 1 ? buf[0] & 0xFF : -1;
        }

        @Override
        public int read(@NotNull byte[] out, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            ByteBuffer outBuffer = ByteBuffer.wrap(out, off, len);
            this.sslBuffer.compact();
            byte[] b = new byte[this.sslBuffer.remaining()];
            int read2 = this.input.read(b);
            ZitiSSLSocket.this.d("read read=" + read2 + " sslBuf=" + this.sslBuffer);
            if (read2 > 0) {
                this.sslBuffer.put(b, 0, read2);
                ZitiSSLSocket.this.d("read read=" + read2 + " sslBuf=" + this.sslBuffer);
                this.sslBuffer.flip();
                while (this.sslBuffer.remaining() > 0 && outBuffer.remaining() > 0) {
                    SSLEngineResult res = ZitiSSLSocket.this.getEngine().unwrap(this.sslBuffer, outBuffer);
                    ZitiSSLSocket.this.v("unwrap cons/prod=" + res.bytesConsumed() + '/' + res.bytesProduced() + ' ' + this.sslBuffer + ' ' + outBuffer);
                    if (res.bytesProduced() != 0) continue;
                }
                ZitiSSLSocket.this.d("sslBuf=" + this.sslBuffer + " outBuffer=" + outBuffer);
                return outBuffer.position();
            }
            return read2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SSLEngineResult.HandshakeStatus.values().length];
            nArray[SSLEngineResult.HandshakeStatus.NEED_WRAP.ordinal()] = 1;
            nArray[SSLEngineResult.HandshakeStatus.NEED_TASK.ordinal()] = 2;
            nArray[SSLEngineResult.HandshakeStatus.NEED_UNWRAP.ordinal()] = 3;
            nArray[SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

