/*
 * Decompiled with CFR 0.152.
 */
package org.openucx.jucx.ucp;

import java.io.Closeable;
import java.nio.ByteBuffer;
import org.openucx.jucx.UcxNativeStruct;
import org.openucx.jucx.ucp.UcpContext;
import org.openucx.jucx.ucp.UcpMemPackParams;

public class UcpMemory
extends UcxNativeStruct
implements Closeable {
    private UcpContext context;
    private ByteBuffer data;
    private long address;
    private long length;
    private int memType;

    private UcpMemory(long nativeId, UcpContext context, long address, long length, int memType) {
        this.setNativeId(nativeId);
        this.address = address;
        this.length = length;
        this.memType = memType;
        this.context = context;
    }

    public void deregister() {
        UcpMemory.unmapMemoryNative(this.context.getNativeId(), this.getNativeId());
        this.setNativeId(null);
        this.data = null;
    }

    public ByteBuffer getRemoteKeyBuffer() {
        ByteBuffer rKeyBuffer = UcpMemory.getRkeyBufferNative(this.context.getNativeId(), this.getNativeId());
        ByteBuffer result = ByteBuffer.allocateDirect(rKeyBuffer.capacity());
        result.put(rKeyBuffer);
        result.clear();
        UcpMemory.releaseRkeyBufferNative(rKeyBuffer);
        return result;
    }

    public ByteBuffer getExportedMkeyBuffer() {
        UcpMemPackParams params = new UcpMemPackParams().exported();
        ByteBuffer mKeyBuffer = UcpMemory.getMkeyBufferNative(this.getNativeId(), params);
        ByteBuffer result = ByteBuffer.allocateDirect(mKeyBuffer.capacity());
        result.put(mKeyBuffer);
        result.clear();
        UcpMemory.releaseMkeyBufferNative(mKeyBuffer);
        return result;
    }

    void setByteBufferReference(ByteBuffer data) {
        this.data = data;
    }

    public long getAddress() {
        return this.address;
    }

    public long getLength() {
        return this.length;
    }

    public int getMemType() {
        return this.memType;
    }

    private static native void unmapMemoryNative(long var0, long var2);

    private static native ByteBuffer getRkeyBufferNative(long var0, long var2);

    private static native void releaseRkeyBufferNative(ByteBuffer var0);

    private static native ByteBuffer getMkeyBufferNative(long var0, UcpMemPackParams var2);

    private static native void releaseMkeyBufferNative(ByteBuffer var0);

    @Override
    public void close() {
        this.deregister();
    }
}

