/*
 * Decompiled with CFR 0.152.
 */
package org.openucx.jucx.examples;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.openucx.jucx.ucp.UcpContext;
import org.openucx.jucx.ucp.UcpMemMapParams;
import org.openucx.jucx.ucp.UcpParams;
import org.openucx.jucx.ucp.UcpWorker;
import org.openucx.jucx.ucp.UcpWorkerParams;

public abstract class UcxBenchmark {
    protected static Map<String, String> argsMap = new HashMap<String, String>();
    protected static Stack<Closeable> resources = new Stack();
    protected static UcpContext context;
    protected static UcpWorker worker;
    protected static int serverPort;
    protected static int numIterations;
    protected static long totalSize;
    protected static UcpMemMapParams allocationParams;
    private static String DESCRIPTION;

    protected static boolean initializeArguments(String[] args) {
        for (String arg : args) {
            if (arg.contains("h")) {
                System.out.println(DESCRIPTION);
                return false;
            }
            String[] parts = arg.split("=");
            argsMap.put(parts[0], parts[1]);
        }
        try {
            serverPort = Integer.parseInt(argsMap.get("p"));
            numIterations = Integer.parseInt(argsMap.get("n"));
            totalSize = Long.parseLong(argsMap.get("t"));
            allocationParams = new UcpMemMapParams().allocate().setLength(totalSize);
            if (argsMap.get("o").compareToIgnoreCase("true") == 0) {
                allocationParams.nonBlocking();
            }
        }
        catch (NumberFormatException ex) {
            System.out.println(DESCRIPTION);
            return false;
        }
        return true;
    }

    protected static void createContextAndWorker() {
        context = new UcpContext(new UcpParams().requestWakeupFeature().requestRmaFeature().requestTagFeature());
        resources.push(context);
        worker = context.newWorker(new UcpWorkerParams());
        resources.push(worker);
    }

    protected static double getBandwithGbits(long nanoTimeDelta, long size) {
        return (double)size * 8.0 / (double)nanoTimeDelta;
    }

    protected static void closeResources() throws IOException {
        while (!resources.empty()) {
            resources.pop().close();
        }
    }

    static {
        DESCRIPTION = "JUCX benchmark.\nRun: \njava -cp jucx.jar org.openucx.jucx.examples.UcxReadBWBenchmarkReceiver [s=host] [p=port] [n=number of iterations]\njava -cp jucx.jar org.openucx.jucx.examples.UcxReadBWBenchmarkSender [s=receiver host] [p=receiver port] [t=total size to transfer]\n\nParameters:\nh - print help\ns - IP address to bind sender listener (default: 0.0.0.0)\np - port to bind sender listener (default: 54321)\nt - total size in bytes to transfer from sender to receiver (default 10000)\no - on demand registration (default: false) \nn - number of iterations (default 5)\n";
        argsMap.put("s", "0.0.0.0");
        argsMap.put("p", "54321");
        argsMap.put("t", "10000");
        argsMap.put("o", "false");
        argsMap.put("n", "5");
    }
}

