/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.station.CSplitDockStation;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.mode.CExternalizedModeArea;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.station.CSplitDockStationHandle;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.ModeAreaListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.util.DockUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalizedCSplitDockStationHandler
extends CSplitDockStationHandle {
    private LocationMode externalMode;
    private Externalized external = new Externalized();

    public ExternalizedCSplitDockStationHandler(CStation<CSplitDockStation> station, CLocationModeManager manager) {
        super(station, manager);
    }

    @Override
    protected LocationMode getNormalMode() {
        return this.externalMode;
    }

    public CExternalizedModeArea asExternalized() {
        return this.external;
    }

    private CStation<?> getBaseStation() {
        DockStation parent = this.getStation().getDockParent();
        while (parent != null) {
            if (!(parent instanceof CommonDockStation)) continue;
            return ((CommonDockStation)parent).getStation();
        }
        throw new IllegalStateException("missing parent station");
    }

    protected class Externalized
    implements CExternalizedModeArea {
        protected Externalized() {
        }

        public DockableProperty getLocation(Dockable child) {
            return ExternalizedCSplitDockStationHandler.this.asNormalModeArea().getLocation(child);
        }

        public boolean setLocation(Dockable dockable, DockableProperty location, AffectedSet set) {
            return ExternalizedCSplitDockStationHandler.this.asNormalModeArea().setLocation(dockable, location, set);
        }

        public String getUniqueId() {
            return ExternalizedCSplitDockStationHandler.this.getCStation().getUniqueId();
        }

        public boolean autoDefaultArea() {
            return false;
        }

        public boolean isLocationRoot() {
            return false;
        }

        public boolean isChild(Dockable dockable) {
            return ExternalizedCSplitDockStationHandler.this.asNormalModeArea().isChild(dockable);
        }

        public DockStation getStation() {
            return ExternalizedCSplitDockStationHandler.this.getStation();
        }

        public void setController(DockController controller) {
        }

        public void setMode(LocationMode mode) {
            ExternalizedCSplitDockStationHandler.this.externalMode = mode;
        }

        public void addModeAreaListener(ModeAreaListener listener) {
            ExternalizedCSplitDockStationHandler.this.add(new CSplitDockStationHandle.ModeAreaListenerWrapper(this, listener));
        }

        public void removeModeAreaListener(ModeAreaListener listener) {
            ExternalizedCSplitDockStationHandler.this.remove(new CSplitDockStationHandle.ModeAreaListenerWrapper(this, listener));
        }

        public CLocation getCLocation(Dockable dockable) {
            CStation base = ExternalizedCSplitDockStationHandler.this.getBaseStation();
            Object baseStation = base.getStation();
            DockableProperty property = DockUtilities.getPropertyChain(baseStation, (Dockable)dockable);
            return base.getStationLocation().expandProperty(baseStation.getController(), property);
        }

        public CLocation getCLocation(Dockable dockable, Location location) {
            CStation base = ExternalizedCSplitDockStationHandler.this.getBaseStation();
            DockableProperty property = location.getLocation();
            if (property == null) {
                return base.getStationLocation();
            }
            return base.getStationLocation().expandProperty(base.getStation().getController(), property);
        }

        public boolean respectWorkingAreas() {
            return false;
        }
    }
}

