/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.group.CGroupMovement;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CSplitDockStation;
import bibliothek.gui.dock.common.location.CMaximizedLocation;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.CMaximizedModeArea;
import bibliothek.gui.dock.common.mode.CNormalModeArea;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.util.CDockUtilities;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorAdapter;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import bibliothek.gui.dock.event.SplitDockListener;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeEvent;
import bibliothek.gui.dock.facile.mode.MaximizedMode;
import bibliothek.gui.dock.facile.mode.MaximizedModeArea;
import bibliothek.gui.dock.facile.mode.ModeArea;
import bibliothek.gui.dock.facile.mode.ModeAreaListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockFullScreenProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSplitDockStationHandle {
    private CStation<CSplitDockStation> station;
    private Normal normal = new Normal();
    private Maximal maximal = new Maximal();
    private LocationMode normalMode;
    private MaximizedMode<?> maximizedMode;
    private CLocationModeManager manager;
    private List<ModeAreaListenerWrapper> listeners = new ArrayList<ModeAreaListenerWrapper>();
    private SplitDockListener fullScreenListener = new SplitDockListener(){

        public void fullScreenDockableChanged(SplitDockStation station, Dockable oldFullScreen, Dockable newFullScreen) {
            ModeAreaListenerWrapper[] array;
            HashSet<Dockable> affected = new HashSet<Dockable>();
            if (oldFullScreen != null) {
                affected.add(oldFullScreen);
            }
            if (newFullScreen != null) {
                affected.add(newFullScreen);
            }
            for (ModeAreaListenerWrapper listener : array = CSplitDockStationHandle.this.listeners.toArray(new ModeAreaListenerWrapper[CSplitDockStationHandle.this.listeners.size()])) {
                listener.fire(affected);
            }
        }
    };
    private VetoableDockRelocatorListener relocatorListener = new VetoableDockRelocatorAdapter(){

        public void dropped(DockRelocatorEvent event) {
            MaximizedModeArea next;
            if (!event.isMove() && (next = CSplitDockStationHandle.this.maximizedMode.getNextMaximizeArea(event.getTarget())) == CSplitDockStationHandle.this.maximal) {
                CSplitDockStationHandle.this.manager.runTransaction(new AffectingRunnable(){

                    public void run(AffectedSet set) {
                        CSplitDockStationHandle.this.maximizedMode.unmaximize((DockStation)CSplitDockStationHandle.this.getStation(), set);
                    }
                });
            }
        }
    };

    public CSplitDockStationHandle(CStation<CSplitDockStation> station, CLocationModeManager manager) {
        this.station = station;
        this.manager = manager;
    }

    protected void add(ModeAreaListenerWrapper listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be empty");
        }
        if (this.listeners.isEmpty()) {
            this.station.getStation().addSplitDockStationListener(this.fullScreenListener);
        }
        this.listeners.add(listener);
    }

    protected void remove(ModeAreaListenerWrapper listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.station.getStation().removeSplitDockStationListener(this.fullScreenListener);
        }
    }

    public SplitDockStation getStation() {
        return this.station.getStation();
    }

    public CStation<CSplitDockStation> getCStation() {
        return this.station;
    }

    public CNormalModeArea asNormalModeArea() {
        return this.normal;
    }

    public CMaximizedModeArea asMaximziedModeArea() {
        return this.maximal;
    }

    protected LocationMode getNormalMode() {
        return this.normalMode;
    }

    private Path normalModeIdentifier() {
        return this.normalExtendedMode().getModeIdentifier();
    }

    private ExtendedMode normalExtendedMode() {
        return this.getNormalMode().getExtendedMode();
    }

    public void dropAside(Dockable dockable) {
        if (dockable.getDockParent() == this.station.getStation()) {
            throw new IllegalStateException("dockable already a child");
        }
        DockableSplitDockTree tree = this.getStation().createTree();
        if (tree.getRoot() == null) {
            tree.root((Object)dockable);
        } else {
            tree.root(tree.horizontal(tree.put((Object[])new Dockable[]{dockable}), tree.unroot()));
        }
        this.getStation().dropTree((SplitDockTree)tree, false);
    }

    protected class Maximal
    implements CMaximizedModeArea {
        private DockController controller;

        protected Maximal() {
        }

        public void addModeAreaListener(ModeAreaListener listener) {
            CSplitDockStationHandle.this.add(new ModeAreaListenerWrapper(this, listener));
        }

        public void removeModeAreaListener(ModeAreaListener listener) {
            CSplitDockStationHandle.this.remove(new ModeAreaListenerWrapper(this, listener));
        }

        public void setMode(LocationMode mode) {
            if (CSplitDockStationHandle.this.maximizedMode != null && mode != null) {
                throw new IllegalStateException("handle already in use");
            }
            CSplitDockStationHandle.this.maximizedMode = (MaximizedMode)mode;
        }

        public void setController(DockController controller) {
            if (this.controller != null) {
                this.controller.getRelocator().removeVetoableDockRelocatorListener(CSplitDockStationHandle.this.relocatorListener);
            }
            this.controller = controller;
            if (controller != null) {
                controller.getRelocator().addVetoableDockRelocatorListener(CSplitDockStationHandle.this.relocatorListener);
            }
        }

        public DockableProperty getLocation(Dockable child) {
            DockableProperty property = DockUtilities.getPropertyChain((DockStation)this.getStation(), (Dockable)child);
            SplitDockFullScreenProperty result = new SplitDockFullScreenProperty();
            result.setSuccessor(property.getSuccessor());
            return result;
        }

        public boolean autoDefaultArea() {
            return true;
        }

        public boolean isLocationRoot() {
            return true;
        }

        public LocationMode getUnmaximizedMode() {
            return CSplitDockStationHandle.this.getNormalMode();
        }

        public void prepareApply(Dockable dockable, AffectedSet affected) {
            CLocationMode normal = (CLocationMode)CSplitDockStationHandle.this.manager.getMode(CSplitDockStationHandle.this.normalModeIdentifier());
            if (normal != null) {
                CSplitDockStationHandle.this.manager.apply(dockable, normal, affected, false);
            }
        }

        public void prepareApply(Dockable dockable, Location history, AffectedSet set) {
            CGroupMovement movement;
            CLocationMode normal;
            boolean remaximize;
            boolean bl = remaximize = history != null && history.getLocation() instanceof SplitDockFullScreenProperty;
            if (!remaximize && CSplitDockStationHandle.this.manager.getMode(dockable) != CSplitDockStationHandle.this.normalExtendedMode() && (normal = (CLocationMode)CSplitDockStationHandle.this.manager.getMode(CSplitDockStationHandle.this.normalModeIdentifier())) != null && (movement = CSplitDockStationHandle.this.maximizedMode.getManager().getGroupBehavior().prepare(CSplitDockStationHandle.this.manager, dockable, normal.getExtendedMode())) != null) {
                CSplitDockStationHandle.this.manager.apply(dockable, normal.getExtendedMode(), movement);
            }
        }

        public Runnable onApply(LocationModeEvent event) {
            MaximizedModeArea area;
            DockableProperty property;
            if (event.isDone()) {
                return null;
            }
            Location location = event.getLocation();
            Dockable dockable = event.getDockable();
            DockableProperty dockableProperty = property = location == null ? null : location.getLocation();
            if (event.getMode().getUniqueIdentifier().equals((Object)CSplitDockStationHandle.this.normalModeIdentifier()) && property != null && property.getSuccessor() == null) {
                MaximizedModeArea area2;
                CLocationMode last = (CLocationMode)CSplitDockStationHandle.this.manager.getCurrentMode(dockable);
                CLocationMode secondLast = (CLocationMode)CSplitDockStationHandle.this.manager.getPreviousMode(dockable);
                if (last != null && secondLast != null && CSplitDockStationHandle.this.normalModeIdentifier().equals((Object)secondLast.getUniqueIdentifier()) && MaximizedMode.IDENTIFIER.equals((Object)last.getUniqueIdentifier()) && (area2 = (MaximizedModeArea)CSplitDockStationHandle.this.maximizedMode.get(location.getRoot())) == this) {
                    area2.setMaximized(dockable, false, null, event.getAffected());
                    event.done(true);
                    return null;
                }
            }
            if (location != null && this.getMaximized() != null) {
                Map<ExtendedMode, DockStation> roots = CSplitDockStationHandle.this.manager.getRepresentations(location.getRoot());
                for (DockStation station : roots.values()) {
                    if (!DockUtilities.isAncestor((DockElement)this.getStation(), (DockElement)station)) continue;
                    CSplitDockStationHandle.this.maximizedMode.unmaximize(this, event.getAffected());
                    break;
                }
            }
            if (CSplitDockStationHandle.this.maximizedMode != null && event.getMode().getUniqueIdentifier().equals((Object)CSplitDockStationHandle.this.normalModeIdentifier()) && (area = CSplitDockStationHandle.this.maximizedMode.getMaximizeArea(dockable)) == this) {
                CSplitDockStationHandle.this.maximizedMode.unmaximize(dockable, event.getAffected());
            }
            return null;
        }

        public Runnable onApply(final LocationModeEvent event, final Dockable replacement) {
            if (event.isDone()) {
                return null;
            }
            if (!event.getMode().getUniqueIdentifier().equals((Object)CSplitDockStationHandle.this.normalModeIdentifier())) {
                CSplitDockStationHandle.this.maximizedMode.unmaximize(this.getStation().getFullScreen(), event.getAffected());
                return new Runnable(){

                    public void run() {
                        if (replacement != null && replacement.getDockParent() != null) {
                            CSplitDockStationHandle.this.maximizedMode.maximize(Maximal.this, replacement, event.getAffected());
                        }
                    }
                };
            }
            return null;
        }

        public String getUniqueId() {
            return CSplitDockStationHandle.this.station.getUniqueId();
        }

        public boolean isChild(Dockable dockable) {
            return this.getStation().getFullScreen() == dockable;
        }

        public SplitDockStation getStation() {
            return (SplitDockStation)CSplitDockStationHandle.this.station.getStation();
        }

        public boolean respectWorkingAreas() {
            return false;
        }

        public Dockable[] getMaximized() {
            Dockable dockable = this.getStation().getFullScreen();
            if (dockable == null) {
                return null;
            }
            return new Dockable[]{dockable};
        }

        public void setMaximized(Dockable dockable, boolean maximized, Location location, AffectedSet set) {
            SplitDockStation station = this.getStation();
            if (!maximized) {
                if (station.getFullScreen() != null && DockUtilities.isAncestor((DockElement)station.getFullScreen(), (DockElement)dockable)) {
                    station.setFullScreen(null);
                }
            } else {
                DockableProperty property;
                DockableProperty dockableProperty = property = location == null ? null : location.getLocation();
                if (property instanceof SplitDockFullScreenProperty && this.getMaximized() != null && this.getStation().drop(dockable, property)) {
                    return;
                }
                if (dockable.getDockParent() == station) {
                    station.setFullScreen(dockable);
                } else {
                    if (dockable.getDockParent() != null) {
                        dockable.getDockParent().drag(dockable);
                    }
                    CSplitDockStationHandle.this.dropAside(dockable);
                    station.setFullScreen(dockable);
                }
            }
            set.add(dockable);
        }

        public boolean isRepresenting(DockStation station) {
            return station == CSplitDockStationHandle.this.station.getStation();
        }

        public CLocation getCLocation(Dockable dockable) {
            DockableProperty property = DockUtilities.getPropertyChain((DockStation)this.getStation(), (Dockable)dockable);
            return this.getCLocation(property);
        }

        public CLocation getCLocation(Dockable dockable, Location location) {
            DockableProperty property = location.getLocation();
            return this.getCLocation(property);
        }

        private CLocation getCLocation(DockableProperty property) {
            CLocation stationLocation = CSplitDockStationHandle.this.station.getStationLocation();
            CMaximizedLocation result = new CMaximizedLocation(stationLocation.findRoot());
            if (property != null) {
                property = property.getSuccessor();
            }
            if (property != null) {
                return result.expandProperty(((CSplitDockStation)CSplitDockStationHandle.this.station.getStation()).getController(), property);
            }
            return result;
        }
    }

    protected class Normal
    implements CNormalModeArea {
        protected Normal() {
        }

        public void setMode(LocationMode mode) {
            CSplitDockStationHandle.this.normalMode = mode;
        }

        public void addModeAreaListener(ModeAreaListener listener) {
            CSplitDockStationHandle.this.add(new ModeAreaListenerWrapper(this, listener));
        }

        public void removeModeAreaListener(ModeAreaListener listener) {
            CSplitDockStationHandle.this.remove(new ModeAreaListenerWrapper(this, listener));
        }

        public boolean autoDefaultArea() {
            return true;
        }

        public boolean isLocationRoot() {
            return true;
        }

        public void setController(DockController controller) {
        }

        public boolean isNormalModeChild(Dockable dockable) {
            if (!this.isChild(dockable)) {
                return false;
            }
            if (this.getStation().getFullScreen() == dockable) {
                return false;
            }
            return this.isWorkingAreaValid(dockable);
        }

        private boolean isWorkingAreaValid(Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                CStation<?> workingArea = ((CommonDockable)dockable).getDockable().getWorkingArea();
                if (workingArea == null) {
                    return CDockUtilities.getFirstWorkingArea(CSplitDockStationHandle.this.station) == null;
                }
                return CDockUtilities.getFirstWorkingArea(CSplitDockStationHandle.this.station) == workingArea;
            }
            return true;
        }

        public DockableProperty getLocation(Dockable child) {
            return DockUtilities.getPropertyChain((DockStation)this.getStation(), (Dockable)child);
        }

        public String getUniqueId() {
            return CSplitDockStationHandle.this.station.getUniqueId();
        }

        public boolean isChild(Dockable dockable) {
            return dockable.getDockParent() == this.getStation() && !CSplitDockStationHandle.this.maximal.isChild(dockable);
        }

        public SplitDockStation getStation() {
            return (SplitDockStation)CSplitDockStationHandle.this.station.getStation();
        }

        public boolean respectWorkingAreas() {
            return true;
        }

        public boolean setLocation(Dockable dockable, DockableProperty location, AffectedSet set) {
            set.add(dockable);
            if (dockable.getDockParent() == CSplitDockStationHandle.this.station.getStation()) {
                if (location != null) {
                    this.cleanFullscreen(set);
                    this.getStation().move(dockable, location);
                    return true;
                }
            } else {
                boolean acceptable = DockUtilities.acceptable((DockStation)this.getStation(), (Dockable)dockable);
                if (acceptable) {
                    if (dockable.getDockParent() != null) {
                        dockable.getDockParent().drag(dockable);
                    }
                    this.cleanFullscreen(set);
                    if (location != null && !this.getStation().drop(dockable, location)) {
                        location = null;
                    }
                    if (location == null && !DockUtilities.isAncestor(CSplitDockStationHandle.this.station.getStation(), (DockElement)dockable)) {
                        this.getStation().drop(dockable);
                    }
                    return true;
                }
            }
            return false;
        }

        private void cleanFullscreen(AffectedSet set) {
            Dockable fullscreen = this.getStation().getFullScreen();
            if (fullscreen != null) {
                CSplitDockStationHandle.this.maximal.setMaximized(fullscreen, false, null, set);
            }
        }

        public CLocation getCLocation(Dockable dockable) {
            DockableProperty property = DockUtilities.getPropertyChain((DockStation)this.getStation(), (Dockable)dockable);
            return CSplitDockStationHandle.this.station.getStationLocation().expandProperty(((CSplitDockStation)CSplitDockStationHandle.this.station.getStation()).getController(), property);
        }

        public CLocation getCLocation(Dockable dockable, Location location) {
            DockableProperty property = location.getLocation();
            if (property == null) {
                return CSplitDockStationHandle.this.station.getStationLocation();
            }
            return CSplitDockStationHandle.this.station.getStationLocation().expandProperty(((CSplitDockStation)CSplitDockStationHandle.this.station.getStation()).getController(), property);
        }

        public CLocation getBaseLocation() {
            return CSplitDockStationHandle.this.station.getStationLocation();
        }

        public boolean isWorkingArea() {
            return CSplitDockStationHandle.this.station.isWorkingArea();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ModeAreaListenerWrapper {
        private ModeAreaListener listener;
        private ModeArea area;

        public ModeAreaListenerWrapper(ModeArea area, ModeAreaListener listener) {
            this.area = area;
            this.listener = listener;
        }

        public void fire(Set<Dockable> dockables) {
            this.listener.internalLocationChange(this.area, dockables);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ModeAreaListenerWrapper) {
                ModeAreaListenerWrapper other = (ModeAreaListenerWrapper)obj;
                return other.area.equals(this.area) && other.listener.equals(this.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.area.hashCode() ^ this.listener.hashCode();
        }
    }
}

