/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.location.AbstractStackholdingLocation;
import bibliothek.gui.dock.common.location.CMaximalExternalizedLocation;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;

public class CExternalizedLocation
extends AbstractStackholdingLocation {
    public static final CLocation STATION = new CLocation(){

        @Deprecated
        public CLocation aside() {
            return this;
        }

        public CLocation getParent() {
            return null;
        }

        public ExtendedMode findMode() {
            return ExtendedMode.EXTERNALIZED;
        }

        public DockableProperty findProperty(DockableProperty successor) {
            if (successor == null) {
                return new ScreenDockProperty(20, 20, 400, 400);
            }
            return successor;
        }

        public String findRoot() {
            return "external";
        }
    };
    private CLocation parent;
    private int x;
    private int y;
    private int width;
    private int height;

    public CExternalizedLocation(int x, int y, int width, int height) {
        this(null, x, y, width, height);
    }

    public CExternalizedLocation(CLocation parent, int x, int y, int width, int height) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public String findRoot() {
        if (this.parent != null) {
            return this.parent.findRoot();
        }
        return "external";
    }

    public ExtendedMode findMode() {
        if (this.parent != null) {
            return this.parent.findMode();
        }
        return ExtendedMode.EXTERNALIZED;
    }

    public DockableProperty findProperty(DockableProperty successor) {
        ScreenDockProperty screen = new ScreenDockProperty(this.x, this.y, this.width, this.height);
        screen.setSuccessor(successor);
        if (this.parent != null) {
            return this.parent.findProperty((DockableProperty)screen);
        }
        return screen;
    }

    public CMaximalExternalizedLocation maximize() {
        return new CMaximalExternalizedLocation(this.x, this.y, this.width, this.height);
    }

    @Deprecated
    public CLocation aside() {
        return this.stack(1);
    }

    public String toString() {
        return "[externalized " + this.x + " " + this.y + " " + this.width + " " + this.height + "]";
    }

    public CLocation getParent() {
        return this.parent;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

