/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.action;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.core.CommonSimpleButtonAction;
import bibliothek.gui.dock.common.action.util.CActionText;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.action.CDropDownItem;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CExtendedModeAction
extends CDropDownItem<Action> {
    private ExtendedMode mode;
    private DockActionIcon iconListener;
    private PropertyValue<KeyStroke> stroke;
    private CControl control;
    private CActionText text;
    private CActionText tooltip;
    private Action action;
    private DockController controller;

    protected CExtendedModeAction(CControl control, ExtendedMode mode, String iconKey, String textKey, String tooltipKey, PropertyKey<KeyStroke> gotoStroke) {
        super(null);
        this.init(control, mode, iconKey, textKey, tooltipKey, gotoStroke);
    }

    protected CExtendedModeAction() {
        super(null);
    }

    protected void init(CControl control, ExtendedMode mode, String iconKey, String textKey, String tooltipKey, PropertyKey<KeyStroke> gotoStroke) {
        this.action = this.createAction();
        this.init(this.action);
        if (control == null) {
            throw new NullPointerException("control is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is null");
        }
        if (iconKey == null) {
            throw new NullPointerException("iconKey is null");
        }
        if (gotoStroke == null) {
            throw new NullPointerException("gotoStroke is null");
        }
        this.control = control;
        this.mode = mode;
        this.iconListener = new DockActionIcon(iconKey, this.action){

            protected void changed(Icon oldValue, Icon newValue) {
                CExtendedModeAction.this.setIcon(newValue);
            }
        };
        this.stroke = new PropertyValue<KeyStroke>(gotoStroke){

            protected void valueChanged(KeyStroke oldValue, KeyStroke newValue) {
                CExtendedModeAction.this.setAccelerator(newValue);
            }
        };
        this.text = new CActionText(textKey, this){

            protected void changed(String oldValue, String newValue) {
                CExtendedModeAction.this.setText(newValue);
            }
        };
        this.tooltip = new CActionText(tooltipKey, this){

            protected void changed(String oldValue, String newValue) {
                CExtendedModeAction.this.setTooltip(newValue);
            }
        };
    }

    protected void setController(DockController controller) {
        this.controller = controller;
        this.stroke.setProperties(controller);
        this.iconListener.setController(controller);
        this.text.setController(controller);
        this.tooltip.setController(controller);
    }

    protected DockController getController() {
        return this.controller;
    }

    protected boolean checkTrigger(KeyEvent event) {
        return true;
    }

    public void action(CDockable dockable) {
        dockable.setExtendedMode(this.mode);
    }

    protected Action createAction() {
        return new Action();
    }

    public class Action
    extends CommonSimpleButtonAction {
        private int count;

        public Action() {
            super(CExtendedModeAction.this);
            this.count = 0;
        }

        protected boolean trigger(KeyEvent event, Dockable dockable) {
            if (CExtendedModeAction.this.checkTrigger(event)) {
                return super.trigger(event, dockable);
            }
            return false;
        }

        public void action(Dockable dockable) {
            while (dockable != null) {
                if (dockable instanceof CommonDockable) {
                    CExtendedModeAction.this.action(((CommonDockable)dockable).getDockable());
                    return;
                }
                DockStation station = dockable.asDockStation();
                if (station == null) {
                    return;
                }
                dockable = station.getFrontDockable();
            }
        }

        protected void bound(Dockable dockable) {
            super.bound(dockable);
            if (this.count == 0) {
                CExtendedModeAction.this.setController(CExtendedModeAction.this.control.intern().getController());
            }
            ++this.count;
        }

        protected void unbound(Dockable dockable) {
            super.unbound(dockable);
            --this.count;
            if (this.count == 0) {
                CExtendedModeAction.this.setController(null);
            }
        }
    }
}

