/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.event.ResizeRequestListener;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.station.CFlapDockStation;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.intern.station.CommonStationDelegate;
import bibliothek.gui.dock.common.intern.station.FlapResizeRequestHandler;
import bibliothek.gui.dock.common.location.CMinimizeAreaLocation;
import bibliothek.gui.dock.common.mode.CMinimizedModeArea;
import bibliothek.gui.dock.common.mode.station.CFlapDockStationHandle;
import bibliothek.gui.dock.common.perspective.CMinimizePerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Path;
import java.awt.BorderLayout;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMinimizeArea
extends JPanel
implements CStation<CFlapDockStation> {
    public static final Path TYPE_ID = new Path(new String[]{"dock", "CMinimizeArea"});
    private CommonDockStation<FlapDockStation, CFlapDockStation> station;
    private ResizeRequestListener request;
    private CControlAccess access;
    private String uniqueId;
    private CMinimizedModeArea area;

    public CMinimizeArea(CControl control, String uniqueId) {
        this.init(control, uniqueId);
    }

    protected CMinimizeArea() {
    }

    protected void init(CControl control, String uniqueId) {
        this.uniqueId = uniqueId;
        this.setLayout(new BorderLayout());
        this.station = control.getFactory().createFlapDockStation(this, new CommonStationDelegate<CFlapDockStation>(){

            @Override
            public boolean isTitleDisplayed(DockTitleVersion title) {
                return true;
            }

            @Override
            public CStation<CFlapDockStation> getStation() {
                return CMinimizeArea.this;
            }

            @Override
            public DockActionSource[] getSources() {
                return new DockActionSource[0];
            }

            @Override
            public CDockable getDockable() {
                return null;
            }
        });
        this.request = new FlapResizeRequestHandler(this.station.getDockStation());
        this.add(this.getStation().getComponent(), "Center");
        this.setDirection(null);
        this.area = new CFlapDockStationHandle(this);
    }

    @Override
    public void setControlAccess(CControlAccess access) {
        if (this.access != null) {
            this.access.getOwner().removeResizeRequestListener(this.request);
            this.access.getLocationManager().getMinimizedMode().remove(this.area.getUniqueId());
        }
        this.access = access;
        if (this.access != null) {
            this.access.getOwner().addResizeRequestListener(this.request);
            this.access.getLocationManager().getMinimizedMode().add(this.area);
        }
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public Path getTypeId() {
        return TYPE_ID;
    }

    @Override
    public CFlapDockStation getStation() {
        return this.station.asDockStation();
    }

    @Override
    public CStationPerspective createPerspective() {
        return new CMinimizePerspective(this.getUniqueId(), this.getTypeId());
    }

    @Override
    public CLocation getStationLocation() {
        return new CMinimizeAreaLocation(this);
    }

    @Override
    public CLocation getDropLocation() {
        if (this.access == null) {
            return null;
        }
        return this.access.getLocationManager().getDropLocation(this);
    }

    @Override
    public boolean isWorkingArea() {
        return false;
    }

    @Override
    public CDockable asDockable() {
        return null;
    }

    public void setDirection(FlapDockStation.Direction direction) {
        CFlapDockStation station = this.getStation();
        if (direction == null) {
            station.setAutoDirection(true);
        } else {
            station.setAutoDirection(false);
            station.setDirection(direction);
        }
    }
}

