/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.event.FigureSelectionEvent;
import org.opentcs.guing.common.util.ImageDirectory;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;

public class PickAttributesAction
extends AbstractSelectedAction {
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar");
    private Set<AttributeKey> excludedAttributes = new HashSet<AttributeKey>(Arrays.asList(AttributeKeys.TRANSFORM, AttributeKeys.TEXT));

    public PickAttributesAction(DrawingEditor editor) {
        super(editor);
        this.putValue("Name", BUNDLE.getString("pickAttributesAction.name"));
        this.putValue("ShortDescription", BUNDLE.getString("pickAttributesAction.shortDescription"));
        ImageIcon icon = ImageDirectory.getImageIcon((String)"/toolbar/colorpicker.png");
        this.putValue("SmallIcon", icon);
        this.putValue("SwingLargeIconKey", icon);
        this.updateEnabledState();
    }

    public void setExcludedAttributes(Set<AttributeKey> a) {
        this.excludedAttributes = a;
    }

    public void actionPerformed(ActionEvent e) {
        this.pickAttributes();
    }

    public void pickAttributes() {
        DrawingEditor editor = this.getEditor();
        Set selection = this.getView().getSelectedFigures();
        if (selection.size() > 0) {
            Figure figure = (Figure)selection.iterator().next();
            for (Map.Entry entry : figure.getAttributes().entrySet()) {
                if (this.excludedAttributes.contains(entry.getKey())) continue;
                editor.setDefaultAttribute((AttributeKey)entry.getKey(), entry.getValue());
            }
        }
    }

    public void selectionChanged(FigureSelectionEvent evt) {
        this.setEnabled(this.getView().getSelectionCount() == 1);
    }
}

