/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw;

import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.gui.JPopupButton;
import org.opentcs.guing.base.model.elements.PathModel;
import org.opentcs.guing.common.components.drawing.figures.PathConnection;
import org.opentcs.guing.common.util.ImageDirectory;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.toolbar.OpenTCSConnectionTool;

public class DefaultPathSelectedAction
extends AbstractSelectedAction {
    private final PathModel.Type pathType;
    private final Tool tool;
    private final JPopupButton popupButton;
    private final ImageIcon largeIcon;
    private final ButtonGroup group;

    public DefaultPathSelectedAction(DrawingEditor editor, Tool tool, JPopupButton popupButton, ButtonGroup group) {
        super(editor);
        this.tool = Objects.requireNonNull(tool);
        this.popupButton = Objects.requireNonNull(popupButton);
        this.group = Objects.requireNonNull(group);
        this.pathType = null;
        this.largeIcon = null;
    }

    public DefaultPathSelectedAction(DrawingEditor editor, Tool tool, PathModel.Type pathType, JPopupButton popupButton, ButtonGroup group) {
        super(editor);
        this.tool = Objects.requireNonNull(tool);
        this.popupButton = Objects.requireNonNull(popupButton);
        this.group = Objects.requireNonNull(group);
        this.pathType = Objects.requireNonNull(pathType);
        this.largeIcon = this.getLargeImageIconByType(pathType);
        this.putValue("Name", pathType.getDescription());
        this.putValue("ShortDescription", pathType.getHelptext());
        this.putValue("SmallIcon", this.getImageIconByType(pathType));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.pathType != null) {
            OpenTCSConnectionTool connectionTool = (OpenTCSConnectionTool)this.tool;
            PathConnection pathConnection = (PathConnection)connectionTool.getPrototype();
            pathConnection.getModel().getPropertyPathConnType().setValue((Object)this.pathType);
            this.popupButton.setText(null);
            this.popupButton.setToolTipText(this.pathType.getHelptext());
            this.popupButton.setIcon((Icon)this.largeIcon);
        }
        this.getEditor().setTool(this.tool);
        this.group.setSelected(this.popupButton.getModel(), true);
    }

    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled());
        } else {
            this.setEnabled(false);
        }
    }

    private ImageIcon getImageIconByType(PathModel.Type pathType) {
        switch (pathType) {
            case DIRECT: {
                return ImageDirectory.getImageIcon((String)"/toolbar/path-direct.22.png");
            }
            case ELBOW: {
                return ImageDirectory.getImageIcon((String)"/toolbar/path-elbow.22.png");
            }
            case SLANTED: {
                return ImageDirectory.getImageIcon((String)"/toolbar/path-slanted.22.png");
            }
            case BEZIER: {
                return ImageDirectory.getImageIcon((String)"/toolbar/path-bezier.22.png");
            }
            case BEZIER_3: {
                return ImageDirectory.getImageIcon((String)"/toolbar/path-bezier.22.png");
            }
            case POLYPATH: {
                return ImageDirectory.getImageIcon((String)"/toolbar/path-polypath.22.png");
            }
        }
        return null;
    }

    private ImageIcon getLargeImageIconByType(PathModel.Type pathType) {
        switch (pathType) {
            case DIRECT: {
                return ImageDirectory.getImageIcon((String)"/toolbar/path-direct-arrow.22.png");
            }
            case ELBOW: {
                return ImageDirectory.getImageIcon((String)"/toolbar/path-elbow-arrow.22.png");
            }
            case SLANTED: {
                return ImageDirectory.getImageIcon((String)"/toolbar/path-slanted-arrow.22.png");
            }
            case BEZIER: {
                return ImageDirectory.getImageIcon((String)"/toolbar/path-bezier-arrow.22.png");
            }
            case BEZIER_3: {
                return ImageDirectory.getImageIcon((String)"/toolbar/path-bezier-arrow.22.png");
            }
            case POLYPATH: {
                return ImageDirectory.getImageIcon((String)"/toolbar/path-polypath-arrow.22.png");
            }
        }
        return null;
    }
}

