/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.opentcs.guing.common.util.ImageDirectory;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw.SendToBackAction;

public class BringToFrontAction
extends AbstractSelectedAction {
    public static final String ID = "edit.bringToFront";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar");

    public BringToFrontAction(DrawingEditor editor) {
        super(editor);
        this.putValue("Name", BUNDLE.getString("bringToFrontAction.name"));
        this.putValue("ShortDescription", BUNDLE.getString("bringToFrontAction.shortDescription"));
        this.putValue("SmallIcon", ImageDirectory.getImageIcon((String)"/toolbar/object-order-front.png"));
        this.updateEnabledState();
    }

    public void actionPerformed(ActionEvent e) {
        final DrawingView view = this.getView();
        final LinkedList<Figure> figures = new LinkedList<Figure>(view.getSelectedFigures());
        BringToFrontAction.bringToFront(view, figures);
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar").getString("bringToFrontAction.undo.presentationName");
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                BringToFrontAction.bringToFront(view, figures);
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                SendToBackAction.sendToBack(view, figures);
            }
        });
    }

    public static void bringToFront(DrawingView view, Collection<Figure> figures) {
        Drawing drawing = view.getDrawing();
        for (Figure figure : drawing.sort(figures)) {
            drawing.bringToFront(figure);
        }
    }
}

