/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;

public class AttributeAction
extends AbstractSelectedAction {
    protected Map<AttributeKey, Object> attributes;

    public AttributeAction(DrawingEditor editor, AttributeKey key, Object value, String name, Icon icon) {
        super(editor);
        this.attributes = new HashMap<AttributeKey, Object>();
        this.attributes.put(key, value);
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.putValue("undoPresentationName", key.getPresentationName());
        this.updateEnabledState();
    }

    public AttributeAction(DrawingEditor editor, Map<AttributeKey, Object> attributes, String name, Icon icon) {
        super(editor);
        this.attributes = attributes == null ? new HashMap() : attributes;
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.updateEnabledState();
    }

    public void actionPerformed(ActionEvent evt) {
        this.applyAttributesTo(this.attributes, this.getView().getSelectedFigures());
    }

    public void applyAttributesTo(final Map<AttributeKey, Object> a, Set<Figure> figures) {
        for (Map.Entry<AttributeKey, Object> entry : a.entrySet()) {
            this.getEditor().setDefaultAttribute(entry.getKey(), entry.getValue());
        }
        final ArrayList<Figure> selectedFigures = new ArrayList<Figure>(figures);
        final ArrayList<Object> restoreData = new ArrayList<Object>(selectedFigures.size());
        for (Figure figure : selectedFigures) {
            restoreData.add(figure.getAttributesRestoreData());
            figure.willChange();
            for (Map.Entry<AttributeKey, Object> entry : a.entrySet()) {
                figure.set(entry.getKey(), entry.getValue());
            }
            figure.changed();
        }
        AbstractUndoableEdit edit = new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                String name = (String)AttributeAction.this.getValue("undoPresentationName");
                if (name == null) {
                    name = (String)AttributeAction.this.getValue("Name");
                }
                return name;
            }

            @Override
            public void undo() {
                super.undo();
                Iterator iRestore = restoreData.iterator();
                for (Figure figure : selectedFigures) {
                    figure.willChange();
                    figure.restoreAttributesTo(iRestore.next());
                    figure.changed();
                }
            }

            @Override
            public void redo() {
                super.redo();
                for (Figure figure : selectedFigures) {
                    figure.willChange();
                    for (Map.Entry entry : a.entrySet()) {
                        figure.set((AttributeKey)entry.getKey(), entry.getValue());
                    }
                    figure.changed();
                }
            }
        };
        this.getDrawing().fireUndoableEditHappened((UndoableEdit)edit);
    }

    protected void updateEnabledState() {
        if (this.getEditor() != null) {
            this.setEnabled(this.getEditor().isEnabled());
        }
    }
}

