/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.event.FigureSelectionEvent;
import org.jhotdraw.undo.CompositeEdit;
import org.opentcs.guing.common.util.ImageDirectory;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;

public class ApplyAttributesAction
extends AbstractSelectedAction {
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar");
    private Set<AttributeKey<?>> excludedAttributes = new HashSet<AttributeKey>(Arrays.asList(AttributeKeys.TRANSFORM, AttributeKeys.TEXT));

    public ApplyAttributesAction(DrawingEditor editor) {
        super(editor);
        this.putValue("Name", BUNDLE.getString("applyAttributesAction.name"));
        this.putValue("ShortDescription", BUNDLE.getString("applyAttributesAction.shortDescription"));
        ImageIcon icon = ImageDirectory.getImageIcon((String)"/toolbar/view-media-visualization.png");
        this.putValue("SmallIcon", icon);
        this.putValue("SwingLargeIconKey", icon);
        this.updateEnabledState();
    }

    public void setExcludedAttributes(Set<AttributeKey<?>> excludedAttributes) {
        this.excludedAttributes = Objects.requireNonNull(excludedAttributes, "excludedAttributes");
    }

    public void actionPerformed(ActionEvent e) {
        this.applyAttributes();
    }

    public void applyAttributes() {
        DrawingEditor editor = this.getEditor();
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar");
        CompositeEdit edit = new CompositeEdit(labels.getString("applyAttributesAction.undo.presentationName"));
        DrawingView view = this.getView();
        view.getDrawing().fireUndoableEditHappened((UndoableEdit)edit);
        for (Figure figure : view.getSelectedFigures()) {
            figure.willChange();
            for (Map.Entry entry : editor.getDefaultAttributes().entrySet()) {
                if (this.excludedAttributes.contains(entry.getKey())) continue;
                figure.set((AttributeKey)entry.getKey(), entry.getValue());
            }
            figure.changed();
        }
        view.getDrawing().fireUndoableEditHappened((UndoableEdit)edit);
    }

    public void selectionChanged(FigureSelectionEvent evt) {
        this.setEnabled(this.getView().getSelectionCount() == 1);
    }
}

