/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class TextAreaDialog
extends JDialog {
    private Collection<String> contents;
    private JPanel buttonPane;
    private JPanel contentPane;
    private JScrollPane contentScrollPane;
    private JTextArea contentTextArea;
    private JButton okButton;
    private JLabel symbolLabel;
    private JPanel symbolPane;
    private JLabel textAreaLabel;

    public TextAreaDialog(Component parent, boolean modal, String description) {
        super(JOptionPane.getFrameForComponent(parent), modal);
        this.initComponents();
        this.textAreaLabel.setText(description);
    }

    public Collection<String> getContent() {
        return new LinkedList<String>(this.contents);
    }

    public void setContent(Collection<String> contents) {
        this.contents = Objects.requireNonNull(contents, "contents");
        this.contentTextArea.setText("");
        contents.stream().map(o -> o + "\n").forEach(this.contentTextArea::append);
    }

    private void initComponents() {
        this.contentPane = new JPanel();
        this.contentScrollPane = new JScrollPane();
        this.contentTextArea = new JTextArea();
        this.textAreaLabel = new JLabel();
        this.buttonPane = new JPanel();
        this.okButton = new JButton();
        this.symbolPane = new JPanel();
        this.symbolLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.contentPane.setPreferredSize(new Dimension(300, 150));
        this.contentPane.setLayout(new BorderLayout());
        this.contentTextArea.setEditable(false);
        this.contentTextArea.setColumns(20);
        this.contentTextArea.setRows(5);
        this.contentScrollPane.setViewportView(this.contentTextArea);
        this.contentPane.add((Component)this.contentScrollPane, "Center");
        this.textAreaLabel.setHorizontalAlignment(0);
        this.textAreaLabel.setText(" ");
        this.contentPane.add((Component)this.textAreaLabel, "North");
        this.getContentPane().add((Component)this.contentPane, "Center");
        this.buttonPane.setLayout(new GridBagLayout());
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextAreaDialog.this.okButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buttonPane.add((Component)this.okButton, gridBagConstraints);
        this.getContentPane().add((Component)this.buttonPane, "South");
        this.symbolPane.setPreferredSize(new Dimension(100, 100));
        this.symbolPane.setLayout(new GridBagLayout());
        this.symbolLabel.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
        this.symbolLabel.setPreferredSize(new Dimension(32, 32));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.symbolPane.add((Component)this.symbolLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.symbolPane, "West");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

