/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.components.layer;

import java.util.Objects;
import javax.inject.Inject;
import org.jhotdraw.draw.Figure;
import org.opentcs.guing.base.model.DrawnModelComponent;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.common.components.drawing.figures.FigureConstants;
import org.opentcs.guing.common.event.DrawingEditorEvent;
import org.opentcs.guing.common.event.DrawingEditorListener;
import org.opentcs.modeleditor.components.layer.LayerEditorModeling;

public class LayerEditorEventHandler
implements DrawingEditorListener {
    private final LayerEditorModeling layerEditor;

    @Inject
    public LayerEditorEventHandler(LayerEditorModeling layerEditor) {
        this.layerEditor = Objects.requireNonNull(layerEditor, "layerEditor");
    }

    public void figureAdded(DrawingEditorEvent e) {
        Figure figure = e.getFigure();
        ModelComponent model = (ModelComponent)figure.get(FigureConstants.MODEL);
        if (model instanceof DrawnModelComponent) {
            this.layerEditor.add((DrawnModelComponent)model);
        }
    }

    public void figureRemoved(DrawingEditorEvent e) {
        Figure figure = e.getFigure();
        ModelComponent model = (ModelComponent)figure.get(FigureConstants.MODEL);
        if (model instanceof DrawnModelComponent) {
            this.layerEditor.remove((DrawnModelComponent)model);
        }
    }

    public void figureSelected(DrawingEditorEvent e) {
    }
}

