/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.components.drawing;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jhotdraw.draw.AbstractFigure;
import org.jhotdraw.draw.Figure;
import org.opentcs.guing.base.event.BlockChangeEvent;
import org.opentcs.guing.base.event.BlockChangeListener;
import org.opentcs.guing.base.model.CompositeModelComponent;
import org.opentcs.guing.base.model.FigureDecorationDetails;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.base.model.elements.BlockModel;
import org.opentcs.guing.common.model.SystemModel;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.guing.common.util.ModelComponentUtil;

public class BlockChangeHandler
implements BlockChangeListener {
    private final Map<BlockModel, Set<FigureDecorationDetails>> blockElementsHistory = new HashMap<BlockModel, Set<FigureDecorationDetails>>();
    private final ModelManager modelManager;

    @Inject
    public BlockChangeHandler(ModelManager modelManager) {
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
    }

    public void courseElementsChanged(BlockChangeEvent e) {
        BlockModel block = (BlockModel)e.getSource();
        Set<FigureDecorationDetails> blockElements = block.getPropertyElements().getItems().stream().map(elementName -> this.modelManager.getModel().getModelComponent(elementName)).filter(modelComponent -> modelComponent instanceof FigureDecorationDetails).map(modelComponent -> (FigureDecorationDetails)modelComponent).collect(Collectors.toSet());
        for (FigureDecorationDetails component : blockElements) {
            component.addBlockModel(block);
        }
        Set<FigureDecorationDetails> removedBlockElements = this.updateBlockElementHistory(block, blockElements);
        for (FigureDecorationDetails component : removedBlockElements) {
            component.removeBlockModel(block);
            Figure figure = this.modelManager.getModel().getFigure((ModelComponent)component);
            ((AbstractFigure)figure).fireFigureChanged();
        }
        this.updateBlock(block);
    }

    public void colorChanged(BlockChangeEvent e) {
        this.updateBlock((BlockModel)e.getSource());
    }

    public void blockRemoved(BlockChangeEvent e) {
        BlockModel block = (BlockModel)e.getSource();
        Set<FigureDecorationDetails> removedBlockElements = this.updateBlockElementHistory(block, new HashSet<FigureDecorationDetails>());
        for (FigureDecorationDetails component : removedBlockElements) {
            component.removeBlockModel(block);
        }
        block.removeBlockChangeListener((BlockChangeListener)this);
        this.updateBlock(block);
    }

    private Set<FigureDecorationDetails> updateBlockElementHistory(BlockModel block, Set<FigureDecorationDetails> newBlockElements) {
        Set<FigureDecorationDetails> oldBlockElements = this.getBlockElements(block);
        HashSet<FigureDecorationDetails> removedBlockElements = new HashSet<FigureDecorationDetails>(oldBlockElements);
        removedBlockElements.removeAll(newBlockElements);
        oldBlockElements.clear();
        oldBlockElements.addAll(newBlockElements);
        return removedBlockElements;
    }

    private Set<FigureDecorationDetails> getBlockElements(BlockModel block) {
        if (!this.blockElementsHistory.containsKey(block)) {
            this.blockElementsHistory.put(block, new HashSet());
        }
        return this.blockElementsHistory.get(block);
    }

    private void updateBlock(BlockModel block) {
        for (Figure figure : ModelComponentUtil.getChildFigures((CompositeModelComponent)block, (SystemModel)this.modelManager.getModel())) {
            ((AbstractFigure)figure).fireFigureChanged();
        }
    }
}

