/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.application.menus.menubar;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import org.jhotdraw.app.action.window.ToggleVisibleAction;
import org.opentcs.guing.common.application.OperationMode;
import org.opentcs.guing.common.application.menus.menubar.ViewPluginPanelsMenu;
import org.opentcs.modeleditor.application.action.ToolBarManager;
import org.opentcs.modeleditor.application.action.ViewActionMap;
import org.opentcs.modeleditor.application.menus.menubar.ViewToolBarsMenu;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;

public class ViewMenu
extends JMenu {
    private final ToolBarManager toolBarManager;
    private final JMenuItem menuAddBitmap;
    private final ViewToolBarsMenu menuViewToolBars;
    private final ViewPluginPanelsMenu menuPluginPanels;
    private final JMenuItem menuItemRestoreDockingLayout;

    @Inject
    public ViewMenu(ViewActionMap actionMap, ToolBarManager toolBarManager, ViewPluginPanelsMenu menuPluginPanels) {
        Objects.requireNonNull(actionMap, "actionMap");
        this.toolBarManager = Objects.requireNonNull(toolBarManager, "toolBarManager");
        Objects.requireNonNull(menuPluginPanels, "menuPluginPanels");
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.mainMenu");
        this.setText(labels.getString("viewMenu.text"));
        this.setToolTipText(labels.getString("viewMenu.tooltipText"));
        this.setMnemonic('V');
        this.menuAddBitmap = new JMenuItem(actionMap.get("view.addBitmap"));
        this.add(this.menuAddBitmap);
        this.addSeparator();
        List<Action> viewActions = this.createToolBarActions();
        if (!viewActions.isEmpty()) {
            this.menuViewToolBars = new ViewToolBarsMenu(viewActions);
            this.add(this.menuViewToolBars);
        } else {
            this.menuViewToolBars = null;
        }
        this.menuPluginPanels = menuPluginPanels;
        menuPluginPanels.setOperationMode(OperationMode.MODELLING);
        this.add((JMenuItem)menuPluginPanels);
        this.menuItemRestoreDockingLayout = new JMenuItem(actionMap.get("openTCS.restoreDockingLayout"));
        this.menuItemRestoreDockingLayout.setText(labels.getString("viewMenu.menuItem_restoreWindowArrangement.text"));
        this.add(this.menuItemRestoreDockingLayout);
    }

    private List<Action> createToolBarActions() {
        ArrayList<Action> toolBarActions = new ArrayList<Action>();
        for (JToolBar curToolBar : this.toolBarManager.getToolBars()) {
            toolBarActions.add((Action)new ToggleVisibleAction((Component)curToolBar, curToolBar.getName()));
        }
        return toolBarActions;
    }
}

