/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.application.action.draw;

import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.tool.CreationTool;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.gui.JPopupButton;
import org.opentcs.guing.base.model.elements.PointModel;
import org.opentcs.guing.common.components.drawing.figures.LabeledPointFigure;
import org.opentcs.guing.common.components.drawing.figures.PointFigure;
import org.opentcs.guing.common.util.ImageDirectory;

public class DefaultPointSelectedAction
extends AbstractSelectedAction {
    private final PointModel.Type pointType;
    private final Tool tool;
    private final JPopupButton popupButton;
    private final ImageIcon largeIcon;
    private final ButtonGroup group;

    public DefaultPointSelectedAction(DrawingEditor editor, Tool tool, JPopupButton popupButton, ButtonGroup group) {
        super(editor);
        this.tool = Objects.requireNonNull(tool);
        this.popupButton = Objects.requireNonNull(popupButton);
        this.group = Objects.requireNonNull(group);
        this.pointType = null;
        this.largeIcon = null;
    }

    public DefaultPointSelectedAction(DrawingEditor editor, Tool tool, PointModel.Type pointType, JPopupButton popupButton, ButtonGroup group) {
        super(editor);
        this.pointType = Objects.requireNonNull(pointType);
        this.tool = Objects.requireNonNull(tool);
        this.popupButton = Objects.requireNonNull(popupButton);
        this.group = Objects.requireNonNull(group);
        this.largeIcon = this.getLargeImageIconByType(pointType);
        this.putValue("Name", pointType.getDescription());
        this.putValue("ShortDescription", pointType.getHelptext());
        this.putValue("SmallIcon", this.getImageIconByType(pointType));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.pointType != null) {
            CreationTool creationTool = (CreationTool)this.tool;
            LabeledPointFigure lpf = (LabeledPointFigure)creationTool.getPrototype();
            PointFigure pointFigure = lpf.getPresentationFigure();
            pointFigure.getModel().getPropertyType().setValue((Object)this.pointType);
            this.popupButton.setText(null);
            this.popupButton.setToolTipText(this.pointType.getHelptext());
            this.popupButton.setIcon((Icon)this.largeIcon);
        }
        this.getEditor().setTool(this.tool);
        this.group.setSelected(this.popupButton.getModel(), true);
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getView() != null && this.getView().isEnabled());
    }

    private ImageIcon getImageIconByType(PointModel.Type pointType) {
        switch (pointType) {
            case HALT: {
                return ImageDirectory.getImageIcon((String)"/toolbar/point-halt.22.png");
            }
            case REPORT: {
                return ImageDirectory.getImageIcon((String)"/toolbar/point-report.22.png");
            }
            case PARK: {
                return ImageDirectory.getImageIcon((String)"/toolbar/point-park.22.png");
            }
        }
        return null;
    }

    private ImageIcon getLargeImageIconByType(PointModel.Type pointType) {
        switch (pointType) {
            case HALT: {
                return ImageDirectory.getImageIcon((String)"/toolbar/point-halt-arrow.22.png");
            }
            case REPORT: {
                return ImageDirectory.getImageIcon((String)"/toolbar/point-report-arrow.22.png");
            }
            case PARK: {
                return ImageDirectory.getImageIcon((String)"/toolbar/point-park-arrow.22.png");
            }
        }
        return null;
    }
}

