/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.application.action;

import java.util.Objects;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.opentcs.guing.common.application.GuiManager;
import org.opentcs.guing.common.application.action.file.ModelPropertiesAction;
import org.opentcs.guing.common.application.action.file.SaveModelAction;
import org.opentcs.guing.common.application.action.file.SaveModelAsAction;
import org.opentcs.modeleditor.application.OpenTCSView;
import org.opentcs.modeleditor.application.action.actions.CreateBlockAction;
import org.opentcs.modeleditor.application.action.actions.CreateLocationTypeAction;
import org.opentcs.modeleditor.application.action.actions.CreateVehicleAction;
import org.opentcs.modeleditor.application.action.app.AboutAction;
import org.opentcs.modeleditor.application.action.file.DownloadModelFromKernelAction;
import org.opentcs.modeleditor.application.action.file.LoadModelAction;
import org.opentcs.modeleditor.application.action.file.NewModelAction;
import org.opentcs.modeleditor.application.action.file.UploadModelToKernelAction;
import org.opentcs.modeleditor.application.action.view.AddBitmapAction;
import org.opentcs.modeleditor.application.action.view.RestoreDockingLayoutAction;
import org.opentcs.thirdparty.guing.common.jhotdraw.application.action.edit.DeleteAction;
import org.opentcs.thirdparty.guing.common.jhotdraw.application.action.edit.SelectAllAction;
import org.opentcs.thirdparty.guing.common.jhotdraw.application.action.edit.UndoRedoManager;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.edit.ClearSelectionAction;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.edit.CopyAction;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.edit.CutAction;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.edit.DuplicateAction;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.edit.PasteAction;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.file.CloseFileAction;

public class ViewActionMap
extends ActionMap {
    @Inject
    public ViewActionMap(OpenTCSView view, UndoRedoManager undoRedoManager, AboutAction aboutAction, ModelPropertiesAction modelPropertiesAction, DownloadModelFromKernelAction loadModelFromKernelAction) {
        Objects.requireNonNull(view, "view");
        Objects.requireNonNull(undoRedoManager, "undoRedoManager");
        Objects.requireNonNull(aboutAction, "aboutAction");
        this.put("file.newModel", new NewModelAction(view));
        this.put("file.loadModel", new LoadModelAction(view));
        this.put("file.saveModel", (Action)new SaveModelAction((GuiManager)view));
        this.put("file.saveModelAs", (Action)new SaveModelAsAction((GuiManager)view));
        this.put("file.modelProperties", (Action)modelPropertiesAction);
        this.put("file.close", new CloseFileAction(view));
        this.put("file.uploadModelToKernel", new UploadModelToKernelAction(view));
        this.put("file.downloadModelFromKernel", loadModelFromKernelAction);
        this.put("edit.undo", undoRedoManager.getUndoAction());
        this.put("edit.redo", undoRedoManager.getRedoAction());
        this.put("edit.cut", (Action)((Object)new CutAction()));
        this.put("edit.copy", (Action)((Object)new CopyAction()));
        this.put("edit.paste", (Action)((Object)new PasteAction()));
        this.put("edit.duplicate", (Action)((Object)new DuplicateAction()));
        this.put("edit.delete", (Action)new DeleteAction());
        this.put("edit.selectAll", (Action)new SelectAllAction());
        this.put("edit.clearSelection", (Action)((Object)new ClearSelectionAction()));
        this.put("openTCS.createLocationType", new CreateLocationTypeAction(view));
        this.put("openTCS.createVehicle", new CreateVehicleAction(view));
        this.put("openTCS.createBlock", new CreateBlockAction(view));
        this.put("view.addBitmap", new AddBitmapAction(view));
        this.put("openTCS.restoreDockingLayout", new RestoreDockingLayoutAction(view));
        this.put("application.about", aboutAction);
    }
}

