/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.application;

import java.util.Objects;
import javax.inject.Inject;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.opentcs.guing.common.application.ProgressIndicator;
import org.opentcs.guing.common.application.ProgressStatus;
import org.opentcs.guing.common.application.StartupProgressStatus;
import org.opentcs.guing.common.event.EventLogger;
import org.opentcs.modeleditor.application.OpenTCSView;

public class PlantOverviewStarter {
    private final ProgressIndicator progressIndicator;
    private final Application application;
    private final OpenTCSView opentcsView;
    private final EventLogger eventLogger;

    @Inject
    public PlantOverviewStarter(ProgressIndicator progressIndicator, Application application, OpenTCSView opentcsView, EventLogger eventLogger) {
        this.progressIndicator = Objects.requireNonNull(progressIndicator, "progressIndicator");
        this.application = Objects.requireNonNull(application, "application");
        this.opentcsView = Objects.requireNonNull(opentcsView, "opentcsView");
        this.eventLogger = Objects.requireNonNull(eventLogger, "eventLogger");
    }

    public void startPlantOverview() {
        this.eventLogger.initialize();
        this.opentcsView.init();
        this.progressIndicator.initialize();
        this.progressIndicator.setProgress((ProgressStatus)StartupProgressStatus.START_PLANT_OVERVIEW);
        this.progressIndicator.setProgress((ProgressStatus)StartupProgressStatus.SHOW_PLANT_OVERVIEW);
        this.opentcsView.setApplication(this.application);
        this.application.show((View)this.opentcsView);
        this.progressIndicator.terminate();
    }
}

