/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.jhotdraw.application.action.draw;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.opentcs.guing.util.ImageDirectory;
import org.opentcs.thirdparty.jhotdraw.application.action.draw.BringToFrontAction;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class SendToBackAction
extends AbstractSelectedAction {
    public static final String ID = "edit.sendToBack";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar");

    public SendToBackAction(DrawingEditor editor) {
        super(editor);
        this.putValue("Name", BUNDLE.getString("sendToBackAction.name"));
        this.putValue("ShortDescription", BUNDLE.getString("sendToBackAction.shortDescription"));
        this.putValue("SmallIcon", ImageDirectory.getImageIcon((String)"/toolbar/object-order-back.png"));
        this.updateEnabledState();
    }

    public void actionPerformed(ActionEvent e) {
        final DrawingView view = this.getView();
        final LinkedList<Figure> figures = new LinkedList<Figure>(view.getSelectedFigures());
        SendToBackAction.sendToBack(view, figures);
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar").getString("sendToBackAction.undo.presentationName");
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                SendToBackAction.sendToBack(view, figures);
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                BringToFrontAction.bringToFront(view, figures);
            }
        });
    }

    public static void sendToBack(DrawingView view, Collection<Figure> figures) {
        Drawing drawing = view.getDrawing();
        for (Figure figure : figures) {
            drawing.sendToBack(figure);
        }
    }
}

