/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.jhotdraw.application.action.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.event.FigureSelectionEvent;
import org.opentcs.thirdparty.jhotdraw.application.action.draw.AttributeAction;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class EditorColorChooserAction
extends AttributeAction {
    protected AttributeKey<Color> key;

    public EditorColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, String name, Icon icon, Map<AttributeKey, Object> fixedAttributes) {
        super(editor, fixedAttributes, name, icon);
        this.key = key;
        this.putValue("Name", name);
        this.putValue("ShortDescription", ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar").getString("editorColorChooserAction.shortDescription"));
        this.putValue("SmallIcon", icon);
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color initialColor = this.getInitialColor();
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar");
        Color chosenColor = JColorChooser.showDialog((Component)e.getSource(), labels.getString("editorColorChooserAction.dialog_colorSelection.title"), initialColor);
        if (chosenColor != null) {
            HashMap<AttributeKey, Object> attr = new HashMap<AttributeKey, Object>(this.attributes);
            attr.put(this.key, chosenColor);
            this.applyAttributesTo(attr, this.getView().getSelectedFigures());
        }
    }

    public void selectionChanged(FigureSelectionEvent evt) {
    }

    protected Color getInitialColor() {
        Color initialColor = (Color)this.getEditor().getDefaultAttribute(this.key);
        if (initialColor == null) {
            initialColor = Color.red;
        }
        return initialColor;
    }
}

