/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.util;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import javax.inject.Inject;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.connector.Connector;
import org.opentcs.guing.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.components.drawing.OpenTCSDrawingView;
import org.opentcs.guing.components.drawing.figures.BitmapFigure;
import org.opentcs.guing.components.drawing.figures.FigureConstants;
import org.opentcs.guing.components.drawing.figures.LabeledFigure;
import org.opentcs.guing.components.drawing.figures.SimpleLineConnection;
import org.opentcs.guing.model.ConnectableModelComponent;
import org.opentcs.guing.model.ModelComponent;
import org.opentcs.guing.model.elements.AbstractConnection;
import org.opentcs.guing.persistence.ModelManager;
import org.opentcs.guing.util.Comparators;

public class FigureCloner {
    private final ModelManager fModelManager;
    private final OpenTCSDrawingEditor fDrawingEditor;

    @Inject
    public FigureCloner(ModelManager modelManager, OpenTCSDrawingEditor drawingEditor) {
        this.fModelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.fDrawingEditor = Objects.requireNonNull(drawingEditor, "drawingEditor");
    }

    public List<Figure> cloneFigures(List<Figure> figuresToClone) {
        SimpleLineConnection clonedFigure;
        ModelComponent clonedModel;
        Objects.requireNonNull(figuresToClone, "figuresToClone");
        TreeSet bufferedConnections = new TreeSet(Comparators.modelComponentsByName());
        HashMap<ConnectableModelComponent, ModelComponent> mClones = new HashMap<ConnectableModelComponent, ModelComponent>();
        ArrayList<Figure> clonedFigures = new ArrayList<Figure>();
        for (Figure figure : figuresToClone) {
            if (figure instanceof LabeledFigure) {
                ConnectableModelComponent model = (ConnectableModelComponent)figure.get(FigureConstants.MODEL);
                if (model != null) {
                    bufferedConnections.addAll(model.getConnections());
                }
                LabeledFigure clonedFigure2 = (LabeledFigure)figure.clone();
                clonedModel = (ModelComponent)clonedFigure2.get(FigureConstants.MODEL);
                if (model != null) {
                    mClones.put(model, clonedModel);
                }
                AffineTransform tx = new AffineTransform();
                tx.translate(50.0, 50.0);
                clonedFigure2.transform(tx);
                this.getActiveDrawingView().getDrawing().add((Figure)clonedFigure2);
                clonedFigures.add((Figure)clonedFigure2);
                continue;
            }
            if (!(figure instanceof BitmapFigure)) continue;
            clonedFigure = new BitmapFigure(new File(((BitmapFigure)figure).getImagePath()));
            AffineTransform tx = new AffineTransform();
            tx.translate(50.0, 50.0);
            clonedFigure.transform(tx);
            this.getActiveDrawingView().addBackgroundBitmap((BitmapFigure)clonedFigure);
        }
        for (Figure figure : figuresToClone) {
            if (!(figure instanceof SimpleLineConnection)) continue;
            clonedFigure = (SimpleLineConnection)figure.clone();
            AbstractConnection model = (AbstractConnection)figure.get(FigureConstants.MODEL);
            clonedModel = (AbstractConnection)clonedFigure.get(FigureConstants.MODEL);
            if (bufferedConnections.contains(model) && model != null) {
                ModelComponent sourcePoint = model.getStartComponent();
                ModelComponent clonedSource = (ModelComponent)mClones.get(sourcePoint);
                Iterator iConnectors = this.fModelManager.getModel().getFigure(clonedSource).getConnectors(null).iterator();
                clonedFigure.setStartConnector((Connector)iConnectors.next());
                ModelComponent destinationPoint = model.getEndComponent();
                ModelComponent clonedDestination = (ModelComponent)mClones.get(destinationPoint);
                iConnectors = this.fModelManager.getModel().getFigure(clonedDestination).getConnectors(null).iterator();
                clonedFigure.setEndConnector((Connector)iConnectors.next());
                clonedModel.setConnectedComponents(clonedSource, clonedDestination);
                clonedModel.updateName();
            }
            this.getActiveDrawingView().getDrawing().add((Figure)clonedFigure);
            clonedFigures.add((Figure)clonedFigure);
        }
        return clonedFigures;
    }

    private OpenTCSDrawingView getActiveDrawingView() {
        return this.fDrawingEditor.getActiveView();
    }
}

