/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.persistence;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JFileChooser;
import org.opentcs.access.CredentialsException;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.to.model.PlantModelCreationTO;
import org.opentcs.components.plantoverview.PlantModelExporter;
import org.opentcs.components.plantoverview.PlantModelImporter;
import org.opentcs.customizations.ApplicationHome;
import org.opentcs.guing.application.ProgressIndicator;
import org.opentcs.guing.application.StatusPanel;
import org.opentcs.guing.exchange.adapter.ProcessAdapterUtil;
import org.opentcs.guing.model.SystemModel;
import org.opentcs.guing.persistence.ModelExportAdapter;
import org.opentcs.guing.persistence.ModelFilePersistor;
import org.opentcs.guing.persistence.ModelFileReader;
import org.opentcs.guing.persistence.ModelImportAdapter;
import org.opentcs.guing.persistence.ModelKernelPersistor;
import org.opentcs.guing.persistence.ModelManagerModeling;
import org.opentcs.guing.persistence.OpenTCSModelManager;
import org.opentcs.guing.util.CourseObjectFactory;
import org.opentcs.guing.util.ModelComponentFactory;
import org.opentcs.guing.util.SynchronizedFileChooser;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTCSModelManagerModeling
extends OpenTCSModelManager
implements ModelManagerModeling {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTCSModelManagerModeling.class);
    private final JFileChooser modelReaderFileChooser;
    private final JFileChooser modelPersistorFileChooser;
    private final ModelKernelPersistor kernelPersistor;
    private final ModelFileReader modelReader;
    private final ModelImportAdapter modelImportAdapter;

    @Inject
    public OpenTCSModelManagerModeling(CourseObjectFactory crsObjFactory, ModelComponentFactory modelComponentFactory, ProcessAdapterUtil procAdapterUtil, Provider<SystemModel> systemModelProvider, StatusPanel statusPanel, @ApplicationHome File homeDir, ModelKernelPersistor kernelPersistor, ModelFileReader modelReader, ModelFilePersistor modelPersistor, ModelImportAdapter modelImportAdapter, ModelExportAdapter modelExportAdapter, ProgressIndicator progressIndicator) {
        super(crsObjFactory, modelComponentFactory, procAdapterUtil, systemModelProvider, statusPanel, homeDir, modelPersistor, modelExportAdapter, progressIndicator);
        this.kernelPersistor = Objects.requireNonNull(kernelPersistor, "kernelPersistor");
        this.modelReader = Objects.requireNonNull(modelReader, "modelReader");
        this.modelReaderFileChooser = new SynchronizedFileChooser(new File(homeDir, "data"));
        this.modelReaderFileChooser.setAcceptAllFileFilterUsed(false);
        this.modelReaderFileChooser.setFileFilter(modelReader.getDialogFileFilter());
        this.modelPersistorFileChooser = new SynchronizedFileChooser(new File(homeDir, "data"));
        this.modelPersistorFileChooser.setAcceptAllFileFilterUsed(false);
        this.modelPersistorFileChooser.setFileFilter(modelPersistor.getDialogFileFilter());
        this.modelImportAdapter = Objects.requireNonNull(modelImportAdapter, "modelImportAdapter");
    }

    @Override
    public boolean loadModel(@Nullable File modelFile) {
        File file;
        File file2 = file = modelFile != null ? modelFile : this.showOpenDialog();
        if (file == null) {
            return false;
        }
        return this.loadModel(file, this.modelReader);
    }

    @Override
    public boolean loadModel(@Nullable File modelFile, ModelFileReader reader) {
        File file;
        Objects.requireNonNull(reader, "reader");
        File file2 = file = modelFile != null ? modelFile : this.showOpenDialog();
        if (file == null) {
            return false;
        }
        try {
            Optional opt = reader.deserialize(file);
            if (!opt.isPresent()) {
                LOG.debug("Loading model canceled.");
                return false;
            }
            this.setModel(this.modelImportAdapter.convert((PlantModelCreationTO)opt.get()));
            this.setCurrentModelFile(file);
            this.initializeSystemModel(this.getModel());
            return true;
        }
        catch (IOException | IllegalArgumentException ex) {
            this.getStatusPanel().setLogMessage(Level.SEVERE, ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.panels.status").getFormatted("openTcsModelManagerModeling.message_notLoaded.text", new Object[]{file.getName()}));
            LOG.info("Error reading file", (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean importModel(PlantModelImporter importer) {
        Objects.requireNonNull(importer, "importer");
        try {
            Optional opt = importer.importPlantModel();
            if (!opt.isPresent()) {
                LOG.debug("Model import cancelled.");
                return false;
            }
            SystemModel newSystemModel = this.modelImportAdapter.convert((PlantModelCreationTO)opt.get());
            this.setModel(newSystemModel);
            this.setCurrentModelFile(null);
            this.initializeSystemModel(this.getModel());
            return true;
        }
        catch (IOException | IllegalArgumentException ex) {
            this.getStatusPanel().setLogMessage(Level.SEVERE, ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.panels.status").getFormatted("openTcsModelManagerModeling.message_notImported.text", new Object[0]));
            LOG.warn("Exception importing model", (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean persistModel(KernelServicePortal portal) {
        try {
            this.setModelName(this.getModel().getName());
            this.getStatusPanel().clear();
            return this.persistModel(this.getModel(), portal, this.kernelPersistor, false);
        }
        catch (IllegalStateException | CredentialsException e) {
            this.getStatusPanel().setLogMessage(Level.SEVERE, ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.panels.status").getString("openTcsModelManagerModeling.message_notSaved.text"));
            LOG.warn("Exception persisting model", e);
            return false;
        }
        catch (IllegalArgumentException e) {
            this.getStatusPanel().setLogMessage(Level.SEVERE, e.getMessage());
            LOG.warn("Exception persisting model", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean exportModel(PlantModelExporter exporter) {
        Objects.requireNonNull(exporter, "exporter");
        try {
            exporter.exportPlantModel(this.getModelExportAdapter().convert(this.getModel()));
            return true;
        }
        catch (IOException | IllegalArgumentException ex) {
            this.getStatusPanel().setLogMessage(Level.SEVERE, ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.panels.status").getString("openTcsModelManagerModeling.message_notExported.text"));
            LOG.warn("Exception exporting model", (Throwable)ex);
            return false;
        }
    }

    private boolean persistModel(SystemModel systemModel, KernelServicePortal portal, ModelKernelPersistor persistor, boolean ignoreError) throws IllegalStateException, KernelRuntimeException {
        Objects.requireNonNull(systemModel, "systemModel");
        Objects.requireNonNull(persistor, "persistor");
        if (!persistor.persist(systemModel, portal, ignoreError)) {
            return false;
        }
        systemModel.setName(this.getModelName());
        return true;
    }

    private File showOpenDialog() {
        if (!this.modelReaderFileChooser.getCurrentDirectory().isDirectory()) {
            this.modelReaderFileChooser.getCurrentDirectory().mkdir();
        }
        if (this.modelReaderFileChooser.showOpenDialog(null) != 0) {
            return null;
        }
        return this.modelReaderFileChooser.getSelectedFile();
    }
}

