/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.components.drawing;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class DeleteEdit
extends AbstractUndoableEdit {
    private final DrawingView drawingView;
    private final ArrayList<Figure> figures = new ArrayList();

    public DeleteEdit(DrawingView drawingView, List<Figure> figures) {
        this.drawingView = Objects.requireNonNull(drawingView, "drawingView");
        this.figures.addAll(figures);
    }

    @Override
    public String getPresentationName() {
        return ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.mainMenu").getString("deleteEdit.presentationName");
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.drawingView.clearSelection();
        for (Figure figure : this.figures) {
            this.drawingView.getDrawing().add(figure);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        for (Figure figure : this.figures) {
            this.drawingView.getDrawing().remove(figure);
        }
    }
}

