/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.action;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.event.ToolAdapter;
import org.jhotdraw.draw.event.ToolEvent;
import org.jhotdraw.draw.event.ToolListener;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.gui.JPopupButton;
import org.opentcs.guing.application.action.ToolButtonListener;
import org.opentcs.guing.application.action.ViewActionMap;
import org.opentcs.guing.application.action.draw.DefaultPointSelectedAction;
import org.opentcs.guing.application.toolbar.CreationToolFactory;
import org.opentcs.guing.application.toolbar.DragTool;
import org.opentcs.guing.application.toolbar.MultipleSelectionTool;
import org.opentcs.guing.application.toolbar.OpenTCSCreationTool;
import org.opentcs.guing.application.toolbar.SelectionToolFactory;
import org.opentcs.guing.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.components.drawing.figures.LabeledLocationFigure;
import org.opentcs.guing.components.drawing.figures.LabeledPointFigure;
import org.opentcs.guing.components.drawing.figures.LinkConnection;
import org.opentcs.guing.components.drawing.figures.PathConnection;
import org.opentcs.guing.event.ResetInteractionToolCommand;
import org.opentcs.guing.model.elements.PathModel;
import org.opentcs.guing.model.elements.PointModel;
import org.opentcs.guing.util.CourseObjectFactory;
import org.opentcs.guing.util.ImageDirectory;
import org.opentcs.thirdparty.jhotdraw.application.action.ButtonFactory;
import org.opentcs.thirdparty.jhotdraw.application.action.draw.DefaultPathSelectedAction;
import org.opentcs.thirdparty.jhotdraw.application.action.draw.SelectSameAction;
import org.opentcs.thirdparty.jhotdraw.application.toolbar.OpenTCSConnectionTool;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;
import org.opentcs.util.event.EventHandler;

public class ToolBarManager
implements EventHandler {
    private final SelectionToolFactory selectionToolFactory;
    private final List<JToolBar> toolBarList = Collections.synchronizedList(new LinkedList());
    private final JToolBar toolBarCreation = new JToolBar();
    private final JToolBar toolBarAlignment = new JToolBar();
    private final JToggleButton selectionToolButton;
    private final JToggleButton dragToolButton;
    private DragTool dragTool;
    private final JPopupButton buttonCreatePoint;
    private final JToggleButton buttonCreateLocation;
    private final JPopupButton buttonCreatePath;
    private final JToggleButton buttonCreateLink;
    private final JButton buttonCreateLocationType;
    private final JButton buttonCreateVehicle;
    private final JButton buttonCreateBlock;

    @Inject
    public ToolBarManager(ViewActionMap actionMap, CourseObjectFactory crsObjFactory, OpenTCSDrawingEditor editor, CreationToolFactory creationToolFactory, SelectionToolFactory selectionToolFactory) {
        Objects.requireNonNull(actionMap, "actionMap");
        Objects.requireNonNull(crsObjFactory, "crsObjFactory");
        Objects.requireNonNull(editor, "editor");
        Objects.requireNonNull(creationToolFactory, "creationToolFactory");
        this.selectionToolFactory = Objects.requireNonNull(selectionToolFactory, "selectionToolFactory");
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar");
        this.toolBarCreation.setActionMap(actionMap);
        this.selectionToolButton = this.addSelectionToolButton(this.toolBarCreation, (DrawingEditor)editor);
        this.dragToolButton = this.addDragToolButton(this.toolBarCreation, (DrawingEditor)editor);
        this.toolBarCreation.addSeparator();
        LabeledPointFigure lpf = crsObjFactory.createPointFigure();
        OpenTCSCreationTool creationTool = creationToolFactory.createCreationTool((Figure)lpf);
        this.buttonCreatePoint = this.pointToolButton(this.toolBarCreation, (DrawingEditor)editor, (Tool)creationTool);
        creationTool.setToolDoneAfterCreation(false);
        LabeledLocationFigure llf = crsObjFactory.createLocationFigure();
        creationTool = creationToolFactory.createCreationTool((Figure)llf);
        this.buttonCreateLocation = this.addToolButton(this.toolBarCreation, (DrawingEditor)editor, (Tool)creationTool, labels.getString("toolBarManager.button_createLocation.tooltipText"), ImageDirectory.getImageIcon((String)"/toolbar/location.22.png"));
        creationTool.setToolDoneAfterCreation(false);
        PathConnection pc = crsObjFactory.createPathConnection();
        OpenTCSConnectionTool connectionTool = creationToolFactory.createConnectionTool((ConnectionFigure)pc);
        this.buttonCreatePath = this.pathToolButton(this.toolBarCreation, (DrawingEditor)editor, (Tool)connectionTool);
        connectionTool.setToolDoneAfterCreation(false);
        LinkConnection lc = crsObjFactory.createLinkConnection();
        connectionTool = creationToolFactory.createConnectionTool((ConnectionFigure)lc);
        this.buttonCreateLink = this.addToolButton(this.toolBarCreation, (DrawingEditor)editor, (Tool)connectionTool, labels.getString("toolBarManager.button_createLink.tooltipText"), ImageDirectory.getImageIcon((String)"/toolbar/link.22.png"));
        connectionTool.setToolDoneAfterCreation(false);
        this.toolBarCreation.addSeparator();
        this.buttonCreateLocationType = new JButton(actionMap.get("openTCS.createLocationType"));
        this.buttonCreateLocationType.setText(null);
        this.toolBarCreation.add(this.buttonCreateLocationType);
        this.buttonCreateVehicle = new JButton(actionMap.get("openTCS.createVehicle"));
        this.buttonCreateVehicle.setText(null);
        this.toolBarCreation.add(this.buttonCreateVehicle);
        this.buttonCreateBlock = new JButton(actionMap.get("openTCS.createBlock"));
        this.buttonCreateBlock.setText(null);
        this.toolBarCreation.add(this.buttonCreateBlock);
        this.toolBarCreation.addSeparator();
        this.toolBarCreation.setName(labels.getString("toolBarManager.toolbar_drawing.title"));
        this.toolBarList.add(this.toolBarCreation);
        ButtonFactory.addAlignmentButtonsTo(this.toolBarAlignment, (DrawingEditor)editor);
        this.toolBarAlignment.setName(labels.getString("toolBarManager.toolbar_alignment.title"));
        this.toolBarList.add(this.toolBarAlignment);
    }

    public List<JToolBar> getToolBars() {
        return this.toolBarList;
    }

    public JToolBar getToolBarCreation() {
        return this.toolBarCreation;
    }

    public JToggleButton getSelectionToolButton() {
        return this.selectionToolButton;
    }

    public JToggleButton getDragToolButton() {
        return this.dragToolButton;
    }

    public JPopupButton getButtonCreatePath() {
        return this.buttonCreatePath;
    }

    public JToggleButton getButtonCreateLink() {
        return this.buttonCreateLink;
    }

    public void onEvent(Object event) {
        if (event instanceof ResetInteractionToolCommand) {
            this.handleToolReset((ResetInteractionToolCommand)event);
        }
    }

    private void handleToolReset(ResetInteractionToolCommand evt) {
        this.selectionToolButton.setSelected(true);
    }

    private JToggleButton addSelectionToolButton(JToolBar toolBar, DrawingEditor editor) {
        ButtonGroup buttonGroup;
        LinkedList<Action> drawingActions = new LinkedList<Action>();
        drawingActions.add((Action)new SelectSameAction(editor));
        MultipleSelectionTool selectionTool = this.selectionToolFactory.createMultipleSelectionTool(drawingActions, new LinkedList<Action>());
        if (toolBar.getClientProperty("toolButtonGroup") instanceof ButtonGroup) {
            buttonGroup = (ButtonGroup)toolBar.getClientProperty("toolButtonGroup");
        } else {
            buttonGroup = new ButtonGroup();
            toolBar.putClientProperty("toolButtonGroup", buttonGroup);
        }
        editor.setTool((Tool)selectionTool);
        final JToggleButton toggleButton = new JToggleButton();
        if (!(toolBar.getClientProperty("toolHandler") instanceof ToolListener)) {
            ToolAdapter toolHandler = new ToolAdapter(){

                public void toolDone(ToolEvent event) {
                    toggleButton.setSelected(true);
                }
            };
            toolBar.putClientProperty("toolHandler", toolHandler);
        }
        toggleButton.setIcon(ImageDirectory.getImageIcon((String)"/toolbar/select-2.png"));
        toggleButton.setText(null);
        toggleButton.setToolTipText(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar").getString("toolBarManager.button_selectionTool.tooltipText"));
        toggleButton.setSelected(true);
        toggleButton.addItemListener((ItemListener)new ToolButtonListener((Tool)selectionTool, editor));
        buttonGroup.add(toggleButton);
        toolBar.add(toggleButton);
        return toggleButton;
    }

    private JToggleButton addDragToolButton(JToolBar toolBar, DrawingEditor editor) {
        final JToggleButton button = new JToggleButton();
        this.dragTool = new DragTool();
        editor.setTool((Tool)this.dragTool);
        if (!(toolBar.getClientProperty("toolHandler") instanceof ToolListener)) {
            ToolAdapter toolHandler = new ToolAdapter(){

                public void toolDone(ToolEvent event) {
                    button.setSelected(true);
                }
            };
            toolBar.putClientProperty("toolHandler", toolHandler);
        }
        URL url = this.getClass().getResource("/org/opentcs/guing/res/symbols/toolbar/cursor-opened-hand.png");
        button.setIcon(new ImageIcon(url));
        button.setText(null);
        button.setToolTipText(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar").getString("toolBarManager.button_dragTool.tooltipText"));
        button.setSelected(false);
        button.addItemListener((ItemListener)new ToolButtonListener((Tool)this.dragTool, editor));
        ButtonGroup group = (ButtonGroup)toolBar.getClientProperty("toolButtonGroup");
        group.add(button);
        toolBar.add(button);
        return button;
    }

    private JPopupButton pointToolButton(JToolBar toolBar, DrawingEditor editor, Tool tool) {
        JPopupButton popupButton = new JPopupButton();
        ButtonGroup group = (ButtonGroup)toolBar.getClientProperty("toolButtonGroup");
        popupButton.setAction((Action)((Object)new DefaultPointSelectedAction(editor, tool, popupButton, group)), new Rectangle(0, 0, 16, 16));
        ToolListener toolHandler = (ToolListener)toolBar.getClientProperty("toolHandler");
        tool.addToolListener(toolHandler);
        for (PointModel.Type type : PointModel.Type.values()) {
            DefaultPointSelectedAction action = new DefaultPointSelectedAction(editor, tool, type, popupButton, group);
            popupButton.add((Action)((Object)action));
            action.setEnabled(true);
        }
        popupButton.setText(null);
        popupButton.setToolTipText(PointModel.Type.values()[0].getHelptext());
        popupButton.setIcon((Icon)ImageDirectory.getImageIcon((String)"/toolbar/point-halt-arrow.22.png"));
        popupButton.setFocusable(true);
        group.add((AbstractButton)popupButton);
        toolBar.add((Component)popupButton);
        return popupButton;
    }

    private JToggleButton addToolButton(JToolBar toolBar, DrawingEditor editor, Tool tool, String toolTipText, ImageIcon iconBase) {
        JToggleButton toggleButton = new JToggleButton();
        toggleButton.setIcon(iconBase);
        toggleButton.setText(null);
        toggleButton.setToolTipText(toolTipText);
        toggleButton.addItemListener((ItemListener)new ToolButtonListener(tool, editor));
        ToolListener toolHandler = (ToolListener)toolBar.getClientProperty("toolHandler");
        tool.addToolListener(toolHandler);
        ButtonGroup group = (ButtonGroup)toolBar.getClientProperty("toolButtonGroup");
        group.add(toggleButton);
        toolBar.add(toggleButton);
        return toggleButton;
    }

    private JPopupButton pathToolButton(JToolBar toolBar, DrawingEditor editor, Tool tool) {
        JPopupButton popupButton = new JPopupButton();
        ButtonGroup group = (ButtonGroup)toolBar.getClientProperty("toolButtonGroup");
        popupButton.setAction((Action)((Object)new DefaultPathSelectedAction(editor, tool, popupButton, group)), new Rectangle(0, 0, 16, 16));
        ToolListener toolHandler = (ToolListener)toolBar.getClientProperty("toolHandler");
        tool.addToolListener(toolHandler);
        for (PathModel.Type type : PathModel.Type.values()) {
            DefaultPathSelectedAction action = new DefaultPathSelectedAction(editor, tool, type, popupButton, group);
            popupButton.add((Action)((Object)action));
            action.setEnabled(true);
        }
        popupButton.setText(null);
        popupButton.setToolTipText(PathModel.Type.values()[0].getHelptext());
        popupButton.setIcon((Icon)ImageDirectory.getImageIcon((String)"/toolbar/path-direct-arrow.22.png"));
        popupButton.setFocusable(true);
        group.add((AbstractButton)popupButton);
        toolBar.add((Component)popupButton);
        return popupButton;
    }
}

