/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.workingset;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.opentcs.access.to.order.DestinationCreationTO;
import org.opentcs.access.to.order.OrderSequenceCreationTO;
import org.opentcs.access.to.order.TransportOrderCreationTO;
import org.opentcs.components.kernel.ObjectNameProvider;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectEvent;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.kernel.workingset.TCSObjectManager;
import org.opentcs.kernel.workingset.TCSObjectRepository;
import org.opentcs.util.Assertions;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportOrderPoolManager
extends TCSObjectManager {
    private static final Logger LOG = LoggerFactory.getLogger(TransportOrderPoolManager.class);
    private final ObjectNameProvider objectNameProvider;

    @Inject
    public TransportOrderPoolManager(@Nonnull TCSObjectRepository objectRepo, @Nonnull @ApplicationEventBus EventHandler eventHandler, @Nonnull ObjectNameProvider orderNameProvider) {
        super(objectRepo, eventHandler);
        this.objectNameProvider = Objects.requireNonNull(orderNameProvider, "orderNameProvider");
    }

    public void clear() {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.addAll(this.getObjectRepo().getObjects(OrderSequence.class));
        objects.addAll(this.getObjectRepo().getObjects(TransportOrder.class));
        for (TCSObject tCSObject : objects) {
            this.getObjectRepo().removeObject(tCSObject.getReference());
            this.emitObjectEvent(null, tCSObject, TCSObjectEvent.Type.OBJECT_REMOVED);
        }
    }

    public TransportOrder createTransportOrder(TransportOrderCreationTO to) throws ObjectUnknownException, ObjectExistsException, IllegalArgumentException {
        TransportOrder newOrder = new TransportOrder(this.nameFor(to), this.toDriveOrders(to.getDestinations())).withCreationTime(Instant.now()).withPeripheralReservationToken(to.getPeripheralReservationToken()).withIntendedVehicle(this.toVehicleReference(to.getIntendedVehicleName())).withType(to.getType()).withDeadline(to.getDeadline()).withDispensable(to.isDispensable()).withWrappingSequence(this.getWrappingSequence(to)).withDependencies(this.getDependencies(to)).withProperties(to.getProperties());
        LOG.info("Transport order is being created: {} -- {}", (Object)newOrder.getName(), (Object)newOrder.getAllDriveOrders());
        this.getObjectRepo().addObject((TCSObject<?>)newOrder);
        this.emitObjectEvent((TCSObject<?>)newOrder, null, TCSObjectEvent.Type.OBJECT_CREATED);
        if (newOrder.getWrappingSequence() != null) {
            OrderSequence sequence;
            OrderSequence prevSeq = sequence = this.getObjectRepo().getObject(OrderSequence.class, newOrder.getWrappingSequence());
            sequence = sequence.withOrder(newOrder.getReference());
            this.getObjectRepo().replaceObject((TCSObject<?>)sequence);
            this.emitObjectEvent((TCSObject<?>)sequence, (TCSObject<?>)prevSeq, TCSObjectEvent.Type.OBJECT_MODIFIED);
        }
        return newOrder;
    }

    public TransportOrder setTransportOrderState(TCSObjectReference<TransportOrder> ref, TransportOrder.State newState) throws ObjectUnknownException {
        TransportOrder previousState = this.getObjectRepo().getObject(TransportOrder.class, ref);
        LOG.info("Transport order's state changes: {} -- {} -> {}", new Object[]{previousState.getName(), previousState.getState(), newState});
        TransportOrder order = previousState.withState(newState);
        this.getObjectRepo().replaceObject((TCSObject<?>)order);
        this.emitObjectEvent((TCSObject<?>)order, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return order;
    }

    public TransportOrder setTransportOrderProcessingVehicle(TCSObjectReference<TransportOrder> orderRef, TCSObjectReference<Vehicle> vehicleRef, List<DriveOrder> driveOrders) throws ObjectUnknownException, IllegalArgumentException {
        TransportOrder order = this.getObjectRepo().getObject(TransportOrder.class, orderRef);
        LOG.info("Transport order's processing vehicle changes: {} -- {} -> {}", new Object[]{order.getName(), this.toObjectName(order.getProcessingVehicle()), this.toObjectName(vehicleRef)});
        TransportOrder previousState = order;
        if (vehicleRef == null) {
            order = order.withProcessingVehicle(null);
            this.getObjectRepo().replaceObject((TCSObject<?>)order);
        } else {
            Vehicle vehicle = this.getObjectRepo().getObject(Vehicle.class, vehicleRef);
            order = order.withProcessingVehicle(vehicle.getReference()).withDriveOrders(driveOrders).withCurrentDriveOrderIndex(0);
            this.getObjectRepo().replaceObject((TCSObject<?>)order);
            if (order.getCurrentDriveOrder() != null) {
                order = order.withCurrentDriveOrderState(DriveOrder.State.TRAVELLING);
                this.getObjectRepo().replaceObject((TCSObject<?>)order);
            }
        }
        this.emitObjectEvent((TCSObject<?>)order, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return order;
    }

    public TransportOrder setTransportOrderDriveOrders(TCSObjectReference<TransportOrder> orderRef, List<DriveOrder> newOrders) throws ObjectUnknownException, IllegalArgumentException {
        TransportOrder previousState = this.getObjectRepo().getObject(TransportOrder.class, orderRef);
        TransportOrder order = previousState.withDriveOrders(newOrders);
        this.getObjectRepo().replaceObject((TCSObject<?>)order);
        this.emitObjectEvent((TCSObject<?>)order, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return order;
    }

    public TransportOrder setTransportOrderNextDriveOrder(TCSObjectReference<TransportOrder> ref) throws ObjectUnknownException {
        TransportOrder previousState = this.getObjectRepo().getObject(TransportOrder.class, ref);
        TransportOrder order = previousState;
        if (order.getCurrentDriveOrder() != null) {
            LOG.info("Transport order's drive order finished: {} -- {}", (Object)order.getName(), (Object)order.getCurrentDriveOrder().getDestination());
            order = order.withCurrentDriveOrderState(DriveOrder.State.FINISHED);
            this.getObjectRepo().replaceObject((TCSObject<?>)order);
            TransportOrder newState = order;
            this.emitObjectEvent((TCSObject<?>)newState, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
            previousState = newState;
            order = order.withCurrentDriveOrderIndex(order.getCurrentDriveOrderIndex() + 1);
            this.getObjectRepo().replaceObject((TCSObject<?>)order);
            newState = order;
            this.emitObjectEvent((TCSObject<?>)newState, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
            previousState = newState;
            if (order.getCurrentDriveOrder() != null) {
                order = order.withCurrentDriveOrderState(DriveOrder.State.TRAVELLING);
                this.getObjectRepo().replaceObject((TCSObject<?>)order);
                newState = order;
                this.emitObjectEvent((TCSObject<?>)newState, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
                previousState = newState;
            }
        }
        this.emitObjectEvent((TCSObject<?>)order, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return order;
    }

    public TransportOrder removeTransportOrder(TCSObjectReference<TransportOrder> ref) throws ObjectUnknownException {
        TransportOrder order = this.getObjectRepo().getObject(TransportOrder.class, ref);
        Assertions.checkArgument((boolean)order.getState().isFinalState(), (String)"Transport order %s is not in a final state.", (Object[])new Object[]{order.getName()});
        this.getObjectRepo().removeObject(ref);
        this.emitObjectEvent(null, (TCSObject<?>)order, TCSObjectEvent.Type.OBJECT_REMOVED);
        return order;
    }

    public OrderSequence createOrderSequence(OrderSequenceCreationTO to) throws ObjectExistsException, ObjectUnknownException {
        OrderSequence newSequence = new OrderSequence(this.nameFor(to)).withType(to.getType()).withIntendedVehicle(this.toVehicleReference(to.getIntendedVehicleName())).withFailureFatal(to.isFailureFatal()).withProperties(to.getProperties());
        LOG.info("Order sequence is being created: {}", (Object)newSequence.getName());
        this.getObjectRepo().addObject((TCSObject<?>)newSequence);
        this.emitObjectEvent((TCSObject<?>)newSequence, null, TCSObjectEvent.Type.OBJECT_CREATED);
        return newSequence;
    }

    public OrderSequence setOrderSequenceFinishedIndex(TCSObjectReference<OrderSequence> seqRef, int index) throws ObjectUnknownException {
        OrderSequence previousState = this.getObjectRepo().getObject(OrderSequence.class, seqRef);
        OrderSequence sequence = previousState.withFinishedIndex(index);
        this.getObjectRepo().replaceObject((TCSObject<?>)sequence);
        this.emitObjectEvent((TCSObject<?>)sequence, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return sequence;
    }

    public OrderSequence setOrderSequenceComplete(TCSObjectReference<OrderSequence> seqRef) throws ObjectUnknownException {
        OrderSequence previousState = this.getObjectRepo().getObject(OrderSequence.class, seqRef);
        OrderSequence sequence = previousState.withComplete(true);
        this.getObjectRepo().replaceObject((TCSObject<?>)sequence);
        this.emitObjectEvent((TCSObject<?>)sequence, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return sequence;
    }

    public OrderSequence setOrderSequenceFinished(TCSObjectReference<OrderSequence> seqRef) throws ObjectUnknownException {
        OrderSequence previousState = this.getObjectRepo().getObject(OrderSequence.class, seqRef);
        OrderSequence sequence = previousState.withFinished(true);
        this.getObjectRepo().replaceObject((TCSObject<?>)sequence);
        this.emitObjectEvent((TCSObject<?>)sequence, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return sequence;
    }

    public OrderSequence setOrderSequenceProcessingVehicle(TCSObjectReference<OrderSequence> seqRef, TCSObjectReference<Vehicle> vehicleRef) throws ObjectUnknownException {
        OrderSequence previousState = this.getObjectRepo().getObject(OrderSequence.class, seqRef);
        LOG.info("Order sequence's processing vehicle changes: {} -- {} -> {}", new Object[]{previousState.getName(), this.toObjectName(previousState.getProcessingVehicle()), this.toObjectName(vehicleRef)});
        OrderSequence sequence = previousState;
        if (vehicleRef == null) {
            sequence = sequence.withProcessingVehicle(null);
            this.getObjectRepo().replaceObject((TCSObject<?>)sequence);
        } else {
            Vehicle vehicle = this.getObjectRepo().getObject(Vehicle.class, vehicleRef);
            sequence = sequence.withProcessingVehicle(vehicle.getReference());
            this.getObjectRepo().replaceObject((TCSObject<?>)sequence);
        }
        this.emitObjectEvent((TCSObject<?>)sequence, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return sequence;
    }

    public OrderSequence removeOrderSequence(TCSObjectReference<OrderSequence> ref) throws ObjectUnknownException {
        OrderSequence previousState;
        OrderSequence sequence = previousState = this.getObjectRepo().getObject(OrderSequence.class, ref);
        this.getObjectRepo().removeObject(ref);
        this.emitObjectEvent(null, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_REMOVED);
        return sequence;
    }

    public void removeFinishedOrderSequenceAndOrders(TCSObjectReference<OrderSequence> ref) throws ObjectUnknownException, IllegalArgumentException {
        OrderSequence previousState = this.getObjectRepo().getObject(OrderSequence.class, ref);
        Assertions.checkArgument((boolean)previousState.isFinished(), (String)"Order sequence %s is not finished", (Object[])new Object[]{previousState.getName()});
        OrderSequence sequence = previousState;
        this.getObjectRepo().removeObject(ref);
        this.emitObjectEvent(null, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_REMOVED);
        for (TCSObjectReference orderRef : sequence.getOrders()) {
            this.removeTransportOrder((TCSObjectReference<TransportOrder>)orderRef);
        }
    }

    private Set<TCSObjectReference<TransportOrder>> getDependencies(TransportOrderCreationTO to) throws ObjectUnknownException {
        HashSet<TCSObjectReference<TransportOrder>> result = new HashSet<TCSObjectReference<TransportOrder>>();
        for (String dependencyName : to.getDependencyNames()) {
            TransportOrder dep = this.getObjectRepo().getObject(TransportOrder.class, dependencyName);
            if (dep == null) {
                throw new ObjectUnknownException(dependencyName);
            }
            result.add((TCSObjectReference<TransportOrder>)dep.getReference());
        }
        return result;
    }

    private TCSObjectReference<OrderSequence> getWrappingSequence(TransportOrderCreationTO to) throws ObjectUnknownException, IllegalArgumentException {
        if (to.getWrappingSequence() == null) {
            return null;
        }
        OrderSequence sequence = this.getObjectRepo().getObject(OrderSequence.class, to.getWrappingSequence());
        if (sequence == null) {
            throw new ObjectUnknownException(to.getWrappingSequence());
        }
        Assertions.checkArgument((!sequence.isComplete() ? 1 : 0) != 0, (String)"Order sequence %s is already complete", (Object[])new Object[]{sequence});
        Assertions.checkArgument((boolean)Objects.equals(to.getType(), sequence.getType()), (String)"Order sequence %s has different type than order %s: %s != %s", (Object[])new Object[]{sequence, to.getName(), sequence.getType(), to.getType()});
        Assertions.checkArgument((boolean)Objects.equals(to.getIntendedVehicleName(), this.getIntendedVehicleName(sequence)), (String)"Order sequence %s has different intended vehicle than order %s: %s != %s", (Object[])new Object[]{sequence, to.getName(), sequence.getIntendedVehicle(), to.getIntendedVehicleName()});
        return sequence.getReference();
    }

    private TCSObjectReference<Vehicle> toVehicleReference(String vehicleName) throws ObjectUnknownException {
        if (vehicleName == null) {
            return null;
        }
        Vehicle vehicle = this.getObjectRepo().getObject(Vehicle.class, vehicleName);
        return vehicle.getReference();
    }

    private List<DriveOrder> toDriveOrders(List<DestinationCreationTO> dests) throws ObjectUnknownException {
        ArrayList<DriveOrder> result = new ArrayList<DriveOrder>(dests.size());
        for (DestinationCreationTO destTo : dests) {
            TCSObject<?> destObject = this.getObjectRepo().getObjectOrNull(destTo.getDestLocationName());
            if (!(destObject instanceof Location) && !(destObject instanceof Point)) {
                throw new ObjectUnknownException(destTo.getDestLocationName());
            }
            result.add(new DriveOrder(new DriveOrder.Destination(destObject.getReference()).withOperation(destTo.getDestOperation()).withProperties(destTo.getProperties())));
        }
        return result;
    }

    @Nullable
    private String getIntendedVehicleName(OrderSequence sequence) {
        return sequence.getIntendedVehicle() == null ? null : sequence.getIntendedVehicle().getName();
    }

    @Nonnull
    private String nameFor(@Nonnull TransportOrderCreationTO to) {
        if (to.hasIncompleteName()) {
            return (String)this.objectNameProvider.apply((Object)to);
        }
        return to.getName();
    }

    @Nonnull
    private String nameFor(@Nonnull OrderSequenceCreationTO to) {
        if (to.hasIncompleteName()) {
            return (String)this.objectNameProvider.apply((Object)to);
        }
        return to.getName();
    }

    @Nullable
    private String toObjectName(TCSObjectReference<?> ref) {
        return ref == null ? null : ref.getName();
    }
}

