/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.workingset;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.util.Assertions;

public class TCSObjectRepository {
    private final Map<Class<?>, Map<String, TCSObject<?>>> objects = new HashMap();

    public void addObject(@Nonnull TCSObject<?> newObject) throws ObjectExistsException {
        Objects.requireNonNull(newObject, "newObject");
        if (this.containsName(newObject.getName())) {
            throw new ObjectExistsException("Object name already exists: " + newObject.getName());
        }
        Map<String, TCSObject<?>> objectsByName = this.objects.get(newObject.getClass());
        if (objectsByName == null) {
            objectsByName = new HashMap();
            this.objects.put(newObject.getClass(), objectsByName);
        }
        objectsByName.put(newObject.getName(), newObject);
    }

    @Nonnull
    public void replaceObject(@Nonnull TCSObject<?> object) throws IllegalArgumentException {
        Objects.requireNonNull(object, "object");
        TCSObject<?> oldObject = this.getObjectOrNull(object.getName());
        Assertions.checkArgument((oldObject != null ? 1 : 0) != 0, (String)"Object named '%s' does not exist", (Object[])new Object[]{object.getName()});
        Assertions.checkArgument((object.getClass() == oldObject.getClass() ? 1 : 0) != 0, (String)"Object named '%s' not an instance of the same class: '%s' != '%s'", (Object[])new Object[]{object.getName(), object.getClass().getName(), oldObject.getClass().getName()});
        this.objects.get(object.getClass()).put(object.getName(), object);
    }

    @Nullable
    public TCSObject<?> getObjectOrNull(@Nonnull TCSObjectReference<?> ref) {
        Objects.requireNonNull(ref);
        return (TCSObject)this.objects.getOrDefault(ref.getReferentClass(), Map.of()).get(ref.getName());
    }

    @Nonnull
    public TCSObject<?> getObject(@Nonnull TCSObjectReference<?> ref) throws ObjectUnknownException {
        TCSObject<?> result = this.getObjectOrNull(ref);
        if (result == null) {
            throw new ObjectUnknownException(ref);
        }
        return result;
    }

    @Nullable
    public <T extends TCSObject<T>> T getObjectOrNull(@Nonnull Class<T> clazz, @Nonnull TCSObjectReference<T> ref) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(ref, "ref");
        TCSObject result = (TCSObject)this.objects.getOrDefault(clazz, Map.of()).get(ref.getName());
        if (clazz.isInstance(result)) {
            return (T)((TCSObject)clazz.cast(result));
        }
        return null;
    }

    @Nonnull
    public <T extends TCSObject<T>> T getObject(@Nonnull Class<T> clazz, @Nonnull TCSObjectReference<T> ref) throws ObjectUnknownException {
        T result = this.getObjectOrNull(clazz, ref);
        if (result == null) {
            throw new ObjectUnknownException(ref);
        }
        return result;
    }

    @Nullable
    public TCSObject<?> getObjectOrNull(@Nonnull String name) {
        Objects.requireNonNull(name, "name");
        return this.objects.values().stream().map(objectsByName -> (TCSObject)objectsByName.get(name)).filter(object -> object != null).findAny().orElse(null);
    }

    @Nonnull
    public TCSObject<?> getObject(@Nonnull String name) throws ObjectUnknownException {
        TCSObject<?> result = this.getObjectOrNull(name);
        if (result == null) {
            throw new ObjectUnknownException(name);
        }
        return result;
    }

    @Nullable
    public <T extends TCSObject<T>> T getObjectOrNull(@Nonnull Class<T> clazz, @Nonnull String name) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(name, "name");
        TCSObject result = (TCSObject)this.objects.getOrDefault(clazz, Map.of()).get(name);
        if (clazz.isInstance(result)) {
            return (T)((TCSObject)clazz.cast(result));
        }
        return null;
    }

    @Nonnull
    public <T extends TCSObject<T>> T getObject(@Nonnull Class<T> clazz, @Nonnull String name) throws ObjectUnknownException {
        T result = this.getObjectOrNull(clazz, name);
        if (result == null) {
            throw new ObjectUnknownException(name);
        }
        return result;
    }

    @Nonnull
    public <T extends TCSObject<T>> Set<T> getObjects(@Nonnull Class<T> clazz) {
        return this.objects.getOrDefault(clazz, Map.of()).values().stream().map(object -> (TCSObject)clazz.cast(object)).collect(Collectors.toSet());
    }

    @Nonnull
    public <T extends TCSObject<T>> Set<T> getObjects(@Nonnull Class<T> clazz, @Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(predicate, "predicate");
        return this.objects.getOrDefault(clazz, Map.of()).values().stream().map(object -> (TCSObject)clazz.cast(object)).filter(predicate).collect(Collectors.toSet());
    }

    @Nonnull
    public TCSObject<?> removeObject(@Nonnull TCSObjectReference<?> ref) throws ObjectUnknownException {
        Objects.requireNonNull(ref, "ref");
        TCSObject obj = (TCSObject)this.objects.getOrDefault(ref.getReferentClass(), Map.of()).remove(ref.getName());
        if (obj == null) {
            throw new ObjectUnknownException(ref);
        }
        return obj;
    }

    private boolean containsName(String name) {
        return this.objects.values().stream().anyMatch(objectsByName -> objectsByName.containsKey(name));
    }
}

