/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.vehicles;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.opentcs.access.LocalKernel;
import org.opentcs.components.Lifecycle;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.VehicleCommAdapterDescription;
import org.opentcs.drivers.vehicle.VehicleCommAdapterFactory;
import org.opentcs.util.Assertions;
import org.opentcs.virtualvehicle.LoopbackCommunicationAdapterDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleCommAdapterRegistry
implements Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(VehicleCommAdapterRegistry.class);
    private final Map<VehicleCommAdapterDescription, VehicleCommAdapterFactory> factories = new TreeMap<VehicleCommAdapterDescription, VehicleCommAdapterFactory>((f1, f2) -> {
        if (f1 instanceof LoopbackCommunicationAdapterDescription && f2 instanceof LoopbackCommunicationAdapterDescription) {
            return 0;
        }
        if (f1 instanceof LoopbackCommunicationAdapterDescription) {
            return 1;
        }
        if (f2 instanceof LoopbackCommunicationAdapterDescription) {
            return -1;
        }
        return f1.getDescription().compareTo(f2.getDescription());
    });
    private boolean initialized;

    @Inject
    public VehicleCommAdapterRegistry(LocalKernel kernel, Set<VehicleCommAdapterFactory> factories) {
        Objects.requireNonNull(kernel, "kernel");
        for (VehicleCommAdapterFactory factory : factories) {
            LOG.info("Setting up communication adapter factory: {}", (Object)factory.getClass().getName());
            this.factories.put(factory.getDescription(), factory);
        }
        Preconditions.checkState((!factories.isEmpty() ? 1 : 0) != 0, (Object)"No adapter factories found.");
    }

    public void initialize() {
        if (this.initialized) {
            LOG.debug("Already initialized.");
            return;
        }
        for (VehicleCommAdapterFactory factory : this.factories.values()) {
            factory.initialize();
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.initialized) {
            LOG.debug("Not initialized.");
            return;
        }
        for (VehicleCommAdapterFactory factory : this.factories.values()) {
            factory.terminate();
        }
        this.initialized = false;
    }

    public List<VehicleCommAdapterFactory> getFactories() {
        return new ArrayList<VehicleCommAdapterFactory>(this.factories.values());
    }

    public VehicleCommAdapterFactory findFactoryFor(VehicleCommAdapterDescription description) {
        Objects.requireNonNull(description, "description");
        Assertions.checkArgument((this.factories.get(description) != null ? 1 : 0) != 0, (String)"No factory for description %s", (Object[])new Object[]{description});
        return this.factories.get(description);
    }

    public List<VehicleCommAdapterFactory> findFactoriesFor(Vehicle vehicle) {
        Objects.requireNonNull(vehicle, "vehicle");
        return this.factories.values().stream().filter(factory -> factory.providesAdapterFor(vehicle)).collect(Collectors.toList());
    }
}

